import { computed } from "vue"
import { useUiStore } from "@/stores/ui"
import { useDomainsStore } from "@/stores/domains"

export function useSelectedDomain(preview = false) {
  const ds = useDomainsStore()
  const ui = useUiStore()
  return computed(() => {
    const { selectedDomainName, previewDomainName } = ui
    const name = preview ? previewDomainName : selectedDomainName
    if (!name) return undefined
    return ds.domains?.find(d => d.domain_name === name)
  })
}