export function buildSort(sort: string, descending: boolean): string {
  return descending ? `-${sort}` : sort
}

export function buildFilter(key: string, value: any, op = 'eq'): string {
  if (Array.isArray(value) && value.length == 2) {
    // Converting range input to >= and <= operators
    const [lower, upper] = value
    const lq = lower ? `${key}:ge:${lower}` : undefined
    const uq = upper ? `${key}:le:${upper}` : undefined
    return lq && uq ? `${lq},${uq}` : lq || uq || ''
  } else {
    // Any single value filter operator
    return value ? `${key}:${op}:${value}` : ''
  }
}