# FETA DomainRadar Project

DomainRadar is an experimental prototype of a threat detection & incident response application. It utilizes machine learning techniques to uncover communication with malicious domains. For a given protected network, the application shows the list of domain names that devices from this network communicate with. For each domain, DomainRadar shows the potential threat level, geolocation data, related security incidents and other information. The application cooperates with IBM QRadar SIEM and Suricata IDS.

Tha classification is based on machine learning (SVM, NN) with features from the following sources:
- **Domain name syntax** – a lexical analysis of the domain name itself;
- **Geolocation** data – analysis of the origin and GPS coordinates of related IP addresses;
- **Whois data** – data available from WHOIS for the given domain;
- **TLS/SLL** certificate information – information from the certificate related to the domain;
- **DNS data** – records from DNS servers available for the given domain.

The DomainRadar app is designed to cooperate with Suricata IDS and QRadar SIEM. It is thus expected that you have working instances of both.

For details, see **DomainRadar-documentation.pdf** which should be attached to the release of this application.

See `domainradar/` for the back-end and core subsystems, `client/` for front-end with the user interface.
