import React from 'react';
import ReactDOM from 'react-dom/client';
import { Route, Routes, BrowserRouter, Outlet } from 'react-router-dom' 

import './App.css';
import "primereact/resources/themes/lara-light-indigo/theme.css";  //theme
import "primereact/resources/primereact.min.css";                  //core css
import "primeicons/primeicons.css";                                //icons
import "bootstrap-icons/font/bootstrap-icons.css";
import "primeflex/primeflex.css";

import App from './App';
import NotFound from './NotFound';
import reportWebVitals from './reportWebVitals';

import Analyzy from './Analyzy';
import PorovnaniZastupitelu from './PorovnaniZastupitelu';
import DochazkaZastupitelu from './DochazkaZastupitelu';
import Home from './Home';
import Hlasovani from './Hlasovani';
import HlasovaniWrapper from './HlasovaniWrapper';
import Zastupitele from './Zastupitele';
import ZastupiteleWrapper from './ZastupiteleWrapper';
import Strany from './Strany';
import StranyWrapper from './StranyWrapper';
import Zasedani from './Zasedani';
import ZasedaniWrapper from './ZasedaniWrapper';

const root = ReactDOM.createRoot(
  document.getElementById("root")
);

const baseUrl = process.env.REACT_APP_BASE_URL;
const apiBaseUrl = process.env.REACT_APP_API_BASE_URL;
const baseName = process.env.REACT_APP_BASENAME;

root.render(
  <BrowserRouter basename={baseName}>
	<Routes>
		<Route path="/" element={<App apiBaseUrl={ apiBaseUrl } />}>
			<Route index element={<Home baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
			<Route path="hlasovani" element={<Outlet />}>
				<Route index element={<Hlasovani baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
				<Route path=":hlasovaniId" element={<HlasovaniWrapper apiBaseUrl={ apiBaseUrl } />} />
			</Route>
			<Route path="zastupitele" element={<Outlet />}>
				<Route index element={<Zastupitele apiBaseUrl={ apiBaseUrl } />} />
				<Route path=":zastupitelId" element={<ZastupiteleWrapper baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
			</Route>
			<Route path="strany" element={<Outlet />}>
				<Route index element={<Strany baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
				<Route path=":stranaId" element={<StranyWrapper baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
			</Route>
			<Route path="zasedani" element={<Outlet />}>
				<Route index element={<Zasedani apiBaseUrl={ apiBaseUrl } />} />
				<Route path=":zasedaniId" element={<ZasedaniWrapper apiBaseUrl={ apiBaseUrl } />} />
			</Route>
			<Route path="analyzy" element={<Outlet />} >
				<Route index element={<Analyzy />} />
				<Route path="porovnani_zastupitelu" element={<PorovnaniZastupitelu baseUrl={ baseUrl } apiBaseUrl={ apiBaseUrl } />} />
				<Route path="dochazka_zastupitelu" element={<DochazkaZastupitelu apiBaseUrl={ apiBaseUrl } />} />
			</Route>
			<Route path="*" element={<NotFound />}/>
		</Route>
	</Routes>
  </BrowserRouter>
);

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
