import React from 'react'
import axios from 'axios'
import LoadingPage from './LoadingPage'
import { Link } from "react-router-dom";
import { Divider } from 'primereact/divider';

class Zastupitele extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            basicData : undefined,
            partiesData: undefined
        }

        this.componentDidMount = this.componentDidMount.bind(this);
    }

    async componentDidMount() {
        await axios.get( this.props.apiBaseUrl + 'generalData').then((response) => {
            this.setState({basicData: response.data});
        });
        await axios.get( this.props.apiBaseUrl + 'partiesData').then((response) => {
            this.setState({partiesData: response.data});
        });
    }

    render() {  
        const { basicData, partiesData } = this.state;

        if (basicData !== undefined && partiesData !== undefined) {
            const len = basicData.pocet_zastupitelu + basicData.pocet_zastupitelek;
            const lenText = len > 55 ? ', někteří tedy byly aktivní pouze část tohoto období' : '';

            return (  
                <div className="m-5 mt-0">
                    <div>
                        <h1 className='text-primary'>Zastupitelé</h1> 
                        <p>
                            Zastupitelstvo města Brna má vždy právě <b>55</b> členů. Ve funkčním obobí 8. zastupitelstva působilo celkem <b>{ len }</b> zastupitelů{ lenText }. 
                            Někteří zastupitelé působili ve více politický stranách, proto se mohou níže objevovat vícekrát.
                        </p>
                    </div>

                    {partiesData.map((party) => (
                        <div key={ party.strana_id + 'strana' } className="surface-0 p-4 shadow-2 border-round mt-5">
                            <div className='flex flex-column md:flex-row mb-3 md:mb-0 align-items-baseline justify-content-between'>
                                <h2 className='ml-2 mt-0'>
                                    <Link 
                                        style={{ color: party.strana_barva }}
                                        to={`/strany/${ party.strana_id }`}
                                        key={party.strana_id}>
                                            { party.strana_zkratka }
                                    </Link>
                                </h2>
                                {
                                    (basicData.nejnovejsi_zasedani.mandaty.find(obj => obj.strana_id === party.strana_id) 
                                    ? 
                                    <div className='ml-2 flex flex-row justify-content-center align-items-center'>
                                        <div className='mr-2'>
                                            <i className="pi pi-users text-3xl mr-1" style={{ color: party.strana_barva }}></i>
                                            <span className='text-3xl font-semibold' style={{ color: party.strana_barva }}>
                                                { basicData.nejnovejsi_zasedani.mandaty.find(obj => obj.strana_id === party.strana_id).pocet_mandatu }
                                            </span>
                                        </div>
                                        <div className="text-900 text-lg mt-2">
                                            { 
                                            basicData.nejnovejsi_zasedani.mandaty.find(obj => obj.strana_id === party.strana_id).pocet_mandatu > 4 
                                            ?
                                            'mandátů'
                                            :
                                            (
                                                basicData.nejnovejsi_zasedani.mandaty.find(obj => obj.strana_id === party.strana_id).pocet_mandatu > 1
                                                ?
                                                'mandáty'
                                                :
                                                'mandát'
                                            )}
                                        </div>
                                    </div>
                                    :
                                    <div className='ml-2 flex flex-row justify-content-center align-items-center'>
                                        <div className='mr-2'>
                                            <i className="pi pi-users text-2xl text-500 mr-1"></i> 
                                            <span className='text-3xl font-semibold text-500'>0</span> 
                                        </div>
                                        <div className="text-900 text-lg mt-2">mandátů</div>
                                    </div>
                                    )
                                }
                            </div>
                            <ul className="list-none p-0 m-0">
                                {
                                    party.pocet_aktivnich > 0
                                    ?
                                    <li key="zastupitele" className="flex align-items-baseline py-2 px-2 flex-wrap">
                                    <div key="sekce" className="w-6 md:w-3 font-medium text-primary">Aktivní zastupitelé</div>
                                    <div key="hodnota" className="w-full md:w-9 md:flex-order-0 flex-order-1">
                                        <ul className='pageUl grid mt-2'>
                                            {
                                                partiesData.find(obj => obj.strana_id === party.strana_id).clenove.map((clen) => 
                                                ( 
                                                    clen.aktivni
                                                    ?
                                                    (<li key={ clen.id } className='col-12 md:col-6 lg:col-4 xl:col-3 font-semibold'>
                                                        <Link
                                                            style={{ color: '#6366F1' }}
                                                            to={`/zastupitele/${clen.id}`}
                                                            key={clen.id}
                                                            >
                                                            {clen.jmeno}
                                                        </Link>
                                                    </li>)
                                                    :
                                                    ''
                                                ))
                                            }
                                        </ul>
                                    </div>
                                </li>
                                    :
                                    ''
                                }
                                {
                                    party.pocet_aktivnich > 0 && party.pocet_neaktivnich > 0
                                    ?
                                    <Divider />
                                    :
                                    ''
                                }
                                {
                                    party.pocet_neaktivnich > 0
                                    ?
                                    <li className="historie flex align-items-baseline py-2 px-2 flex-wrap">
                                        <div key="sekce" className="w-6 md:w-3 font-medium text-500">Historie</div>
                                        <div key="hodnota" className="w-full md:w-9 md:flex-order-0 flex-order-1">
                                            <ul className='historieUl grid mt-2'>
                                                {
                                                    partiesData.find(obj => obj.strana_id === party.strana_id).clenove.map((clen) => 
                                                    ( 
                                                        clen.aktivni
                                                        ?
                                                        ''
                                                        :
                                                        (<li key={ clen.id } className='col-12 md:col-6 lg:col-4 xl:col-3 font-semibold'>
                                                            <Link
                                                                style={{ color: '#9E9E9E' }}
                                                                to={`/zastupitele/${clen.id}`}  
                                                                key={clen.id}
                                                                >
                                                                {clen.jmeno}
                                                            </Link>
                                                        </li>)
                                                    ))
                                                }
                                            </ul>
                                        </div>
                                    </li>
                                    :
                                    ''
                                }
                            </ul>
                        </div>
                    ))}
                </div>
            )  
        } else {
            return (
                <LoadingPage />
            );   
        }
    }  
}

export default Zastupitele