import React from 'react'  
import axios from 'axios'
import LoadingPage from './LoadingPage'
import { Link } from "react-router-dom";
import { Dropdown } from 'primereact/dropdown';

class Zasedani extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            sessionsData : undefined,
            selectedYear: { name: '2022', code: '2022' }
        }

        this.options = [
            { name: '2022', code: '2022' },
            { name: '2021', code: '2021' },
            { name: '2020', code: '2020' },
            { name: '2019', code: '2019' },
            { name: '2018', code: '2018' }
        ];

        this.componentDidMount = this.componentDidMount.bind(this);
        this.onOptionChange = this.onOptionChange.bind(this);
    }

    onOptionChange(e) {
        this.setState({ selectedYear: e.value });
    }

    async componentDidMount() {
        await axios.get( this.props.apiBaseUrl + 'sessionsData').then((response) => {
            this.setState({ sessionsData: response.data });
        });
    }
    
    render() {
        const { sessionsData } = this.state;
 
        if (sessionsData !== undefined) {
            let cnt = sessionsData.map((session) => session.datum.includes(this.state.selectedYear.code) ? 1 : 0).reduce((partialSum, a) => partialSum + a, 0);

            return (
                <div className="m-5 mt-0">
                    <div className="mb-5">
                        <h1 className='text-primary'>Zasedání</h1> 
                        <p>
                            Ve funkčním obobí 8. zastupitelstva proběhlo v zasedací síni Nové radnice na Dominikánském náměstí celkem <b>{ sessionsData.length }</b> zasedání. 
                            Účast zastupitelů na jednotlivých zasedáních je počítána z celkového počtu zastupitelů (tj. 55) a jsou v ní započítáni jak zcela, tak částečně přítomní zastupitelé.
                        </p>
                    </div>

                    <div className="pt-3 flex flex-column md:flex-row">
                        <Dropdown value={this.state.selectedYear} options={this.options} onChange={this.onOptionChange} optionLabel="name" />
                        <p className='pl-3'>Ve zvoleném roce se {cnt in [2,3,4] ? 'uskutečnila' : 'uskutečnilo' } celkem <b>{ cnt }</b>&nbsp;zasedání.</p>
                    </div>

                    <div className='grid mt-5'>
                        {sessionsData.map((session) => 
                            (
                                session.datum.includes(this.state.selectedYear.code)
                                ?
                                (<div key={ 'zasedani'+session.cislo_zasedani } className="col-12 md:col-6 lg:col-4 xl:col-3 px-5 mt-4 mb-4">
                                    <div className='p-3 shadow-2 mb-3 flex flex-column justify-content-center border-round -ml-4 sm:ml-0' style={{ width: '90%', margin: 'auto', minHeight: '160px', minWidth: '270px' }}>
                                        <h2 className='ml-2 mt-0'>
                                            <Link 
                                                style={{ color: '#6366F1' }}
                                                to={`/zasedani/${ parseInt(session.cislo_zasedani) }`}
                                                key={session.cislo_zasedani}>
                                                    <span className='font-medium'>Zasedání č. </span>{ 'Z8/' + session.cislo_zasedani }
                                            </Link>
                                        </h2>
                                        <div className='ml-2 mb-2 flex flex-row justify-content-start align-items-end'>
                                            <div className='mr-1'>
                                                <i className="pi bi-calendar text-xl mr-2" style={{ color: '#6366F1' }}></i>
                                                <span className='text-xl font-semibold' style={{ color: '#6366F1' }}>
                                                    { session.datum }
                                                </span>
                                            </div>
                                        </div>
                                        <div className='ml-2 mb-2 flex flex-row justify-content-start align-items-end'>
                                            <div className='mr-1'>
                                                <i className="pi bi-check2-square text-xl mr-2" style={{ color: '#6366F1' }}></i>
                                                <span className='text-xl font-semibold' style={{ color: '#6366F1' }}>
                                                    { session.pocet_platnych_hlasovani }
                                                </span>
                                            </div>
                                            <div className="text-900 text-lg mt-2">platných hlasování</div>
                                        </div>
                                        <div className='ml-2 flex flex-row justify-content-start align-items-end'>
                                            <div className='mr-1'>
                                                <i className="pi pi-users text-xl mr-2" style={{ color: '#6366F1' }}></i>
                                                <span className='text-xl font-semibold' style={{ color: '#6366F1' }}>
                                                { Math.round(session.ucast/55*100) }%
                                                </span>
                                            </div>
                                            <div className="text-900 text-lg mt-2">účast</div>
                                        </div>
                                    </div>
                                </div>)
                                :
                                ''
                            )
                        )}
                    </div>
                </div>
            );
        } else {
            return (
                <LoadingPage />
            );   
        }
    }
}

export default Zasedani
