
import React from 'react'  
import { Chart } from 'primereact/chart';
import { Dropdown } from 'primereact/dropdown';

class SummaryVotesGraph extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            partiesStats: this.props.partiesStats,
            selectedVoteOption: { name: 'ano', code: 1 }
        }

        this.options = [
            { name: 'ano', code: 1 },
            { name: 'ne', code: 2 },
            { name: 'zdržel/a se', code: 3 },
            { name: 'nehlasoval/a', code: 4 },
            { name: 'nepřítomen/nepřítomna', code: 5 }
        ];

        this.onOptionChange = this.onOptionChange.bind(this);
    }

    onOptionChange(e) {
        this.setState({ selectedVoteOption: e.value });
    }

    render() {
        const { partiesStats, selectedVoteOption } = this.state;
        const { baseUrl } = this.props;

        if (partiesStats !== undefined && baseUrl !== undefined) {        
            function dataSummaryVotes(option) {
                let datasets = partiesStats.map((party) => 
                    ({
                        label: party.strana_zkratka,
                        backgroundColor: party.strana_barva,
                        data: [
                            party.celkove_hlasy[option]
                        ]
                    }));
                let data = {
                    labels: [''],
                    datasets: datasets
                };
                return data;
            }

            let voteDataAno = dataSummaryVotes ('ano');
            let voteDataNe = dataSummaryVotes ('ne');
            let voteDataZdrzelSe = dataSummaryVotes ('zdržel se');
            let voteDataNehlasoval = dataSummaryVotes ('nehlasoval');
            let voteDataNeprit = dataSummaryVotes ('nepřít.');

            function selectedData(){
                switch (selectedVoteOption.code) {
                    case 1:
                        return voteDataAno;
                    case 2:
                        return voteDataNe;
                    case 3:
                        return voteDataZdrzelSe;
                    case 4:
                        return voteDataNehlasoval;
                    case 5:
                        return voteDataNeprit;
                    default:
                        break;
                }
            }
            let voteData = selectedData();

            const voteHorizontalOptions = {
                indexAxis: 'y',
                maintainAspectRatio: false,
                aspectRatio: .8,
                plugins: {
                    legend: {
                        labels: {
                            color: '#495057'
                        }
                    }
                },
                scales: {
                    x: {
                        ticks: {
                            color: '#495057'
                        },
                        grid: {
                            color: '#ebedef'
                        }
                    },
                    y: {
                        ticks: {
                            color: '#495057'
                        },
                        grid: {
                            color: '#ebedef'
                        }
                    }
                },
                'onHover': function (evt, item) {
                    if (item[0] !== undefined) {
                        evt.native.target.style.cursor = 'pointer';
                    } else {
                        evt.native.target.style.cursor = 'default';
                    }
                },
                'onClick': function (evt, item) {
                    if (item[0] !== undefined) {
                        let actItem = voteData.datasets[item[0].datasetIndex].label
                        let partyId = partiesStats.find(obj => obj.strana_zkratka === actItem).strana_id;
                        let voteOptionId = selectedVoteOption.code;
                        
                        // REDIRECT
                        window.location.href = baseUrl + "hlasovani?pohled=strana&strana=" + partyId + "&vysledek_volice=" + voteOptionId + "&pouze_platna=true";
                    }
                }
            };

            return (
                <div className='mb-5'>
                    <h4 className='font-medium'>Odpověď: 
                        <span className='ml-2'>
                        <Dropdown value={selectedVoteOption} options={this.options} onChange={this.onOptionChange} optionLabel="name" />    
                        </span>
                    </h4>
                    <Chart type="bar" data={ voteData } options={ voteHorizontalOptions } height="250px" width="100%" />
                </div>
            );
        }
    }
}

export default SummaryVotesGraph;
