import React from 'react'  
import PorovnaniDetail from './PorovnaniDetail'
import { Dropdown } from 'primereact/dropdown';
import { Chip } from 'primereact/chip';

class PorovnaniZastupitelu extends React.Component {  
    constructor(props) {
        super(props);

        const searchParams = new URLSearchParams(window.location.search);
        let firstMemberValue = searchParams.get("prvni_clen") || null;
        let secondMemberValue = searchParams.get("druhy_clen") || null;
        
        this.members = [
            {name: "David Ale\u0161 (Nezávislí pro Brno)", code: 2}, {name: "V\u00edt Beran (KDU-ČSL)", code: 25}, {name: "Jana Bohu\u0148ovsk\u00e1 (ODS)", code: 33}, {name: "Petr Bo\u0159eck\u00fd (ANO 2011)", code: 3}, {name: "Anton\u00edn Crha (KDU-ČSL)", code: 26}, {name: "Krist\u00fdna \u010cern\u00e1 (roz. \u0160varcov\u00e1; ODS)", code: 56}, {name: "Ren\u00e9 \u010cern\u00fd (ANO 2011)", code: 4}, {name: "R\u00f3bert \u010cuma (Piráti)", code: 46}, {name: "Pavel Dvo\u0159\u00e1k (Nezávislí pro Brno)", code: 5}, {name: "Ji\u0159\u00ed Falt\u00fdnek (Nezávislí pro Brno)", code: 6}, {name: "Ivan Fencl (SPD)", code: 52}, {name: "Marek Fi\u0161er (Piráti)", code: 47}, {name: "Mark\u00e9ta Gregorov\u00e1 (Piráti)", code: 48}, {name: "David Grund (ODS)", code: 34}, {name: "Ji\u0159\u00ed Herman (ODS)", code: 35}, {name: "Petr Hlad\u00edk (KDU-ČSL)", code: 27}, {name: "Michal Chl\u00e1dek (ODS)", code: 36}, {name: "Filip Chv\u00e1tal (KDU-ČSL)", code: 28}, {name: "Ji\u0159\u00ed Ides (ČSSD)", code: 20}, {name: "Jitka Ivi\u010di\u010dov\u00e1 (KDU-ČSL)", code: 29}, {name: "Marek Jan\u00ed\u010dek (ANO 2011)", code: 7}, {name: "Pavel Jank\u016fj (ODS)", code: 37}, {name: "Kate\u0159ina Jaro\u0161ov\u00e1 (ANO 2011)", code: 8}, {name: "Ludv\u00edk Kadlec (ODS)", code: 38}, {name: "Karel Kalivoda (ANO 2011)", code: 9}, {name: "Jaroslav Kame\u0148 (Piráti)", code: 59}, {name: "Karin Karasov\u00e1 (ANO 2011)", code: 10}, {name: "Robert Kerndl (ODS)", code: 39}, {name: "Ji\u0159\u00ed Kment (SPD)", code: 53}, {name: "Tom\u00e1\u0161 Kol\u00e1\u010dn\u00fd (Piráti)", code: 49}, {name: "\u0160\u00e1rka Korke\u0161ov\u00e1 (Nezávislí pro Brno)", code: 11}, {name: "Ond\u0159ej Kotas (Piráti)", code: 50}, {name: "Petr Kratochv\u00edl (ODS)", code: 40}, {name: "Iva Kremitovsk\u00e1 (Nezávislí pro Brno)", code: 12}, {name: "Filip Leder (KDU-ČSL)", code: 30}, {name: "Luk\u00e1\u0161 Mamula (Piráti)", code: 51}, {name: "Ji\u0159\u00ed Mihola (KDU-ČSL)", code: 31}, {name: "Richard Mr\u00e1zek (ANO 2011)", code: 13}, {name: "Ren\u00e9 Novotn\u00fd (ANO 2011)", code: 14}, {name: "Ji\u0159\u00ed Novotn\u00fd (ČSSD)", code: 58}, {name: "Ji\u0159\u00ed Oliva (ČSSD)", code: 21}, {name: "Alena Pavlasov\u00e1 (Piráti)", code: 60}, {name: "Andrea Pazderov\u00e1 (ODS)", code: 41}, {name: "Lucie Pokorn\u00e1 (Nezávislí pro Brno)", code: 15}, {name: "David Pokorn\u00fd (ODS)", code: 42}, {name: "Oliver Posp\u00ed\u0161il (ČSSD)", code: 22}, {name: "V\u00edt Pr\u00fdgl (ANO 2011)", code: 16}, {name: "Martin P\u0159\u00edborsk\u00fd (ODS)", code: 43}, {name: "Jana P\u0159ikrylov\u00e1 (SPD)", code: 54}, {name: "Pavel S\u00e1zavsk\u00fd (ČSSD)", code: 23}, {name: "Petr Sou\u010dek (ANO 2011)", code: 17}, {name: "Monika Spilkov\u00e1 (Piráti)", code: 57}, {name: "Pavel Stan\u011bk (ANO 2011)", code: 18}, {name: "Jaroslav Such\u00fd (KDU-ČSL)", code: 32}, {name: "Lucie \u0160afr\u00e1nkov\u00e1 (SPD)", code: 55}, {name: "David Trllo (ODS)", code: 45}, {name: "Mark\u00e9ta Va\u0148kov\u00e1 (ODS)", code: 1}, {name: "Marek Viskot (ČSSD)", code: 24}, {name: "Petr Vok\u0159\u00e1l (ANO 2011)", code: 19}
        ];

        this.state = {
            firstMember: firstMemberValue !== null ? this.members.find(element => element.code === parseInt(firstMemberValue)) : null,
            secondMember: secondMemberValue !== null ? this.members.find(element => element.code === parseInt(secondMemberValue)) : null
        }

        this.onFirstMemberChange = this.onFirstMemberChange.bind(this);
        this.onSecondMemberChange = this.onSecondMemberChange.bind(this);
    }

    setParams(key, value) {
        const url = new URL(window.location);
        url.searchParams.set(key, value);
        window.history.pushState({}, '', url);
    }

    onFirstMemberChange(e) {
        this.setState({ firstMember: e.value });
        if (e.value !== undefined) {
            // vse ok
            this.setParams('prvni_clen', e.value.code);
        } else {
            // zruseni filtru
            this.setState({ firstMember: null });
            const url = new URL(window.location);
            url.searchParams.delete('prvni_clen');
            window.history.pushState({}, '', url);  
        }
    }

    onSecondMemberChange(e) {
        this.setState({ secondMember: e.value });
        if (e.value !== undefined) {
            // vse ok
            this.setParams('druhy_clen', e.value.code);
        } else {
            // zruseni filtru
            this.setState({ secondMember: null });
            const url = new URL(window.location);
            url.searchParams.delete('druhy_clen');
            window.history.pushState({}, '', url);  
        }
    }
        
    render() {  
        return ( 
            <div className="m-5 mt-0">
                
                <h1 className='text-primary'>Analýzy: porovnání zastupitelů</h1> 
                { (this.state.firstMember === null || this.state.secondMember === null) || ( this.state.firstMember === this.state.secondMember)
                ?
                <p>Vyberte, prosím, dva různé zastupitele.</p>
                :
                ''
                }
                <div className='flex flex-column md:flex-row'>
                    <Dropdown className='md:mr-5' style={{width:"320px"}} value={this.state.firstMember} options={this.members} onChange={this.onFirstMemberChange} optionLabel="name" filter showClear filterBy="name" placeholder="Vyberte prvního člena" />
                    <Dropdown className='mt-3 md:mt-0' style={{width:"320px"}} value={this.state.secondMember} options={this.members} onChange={this.onSecondMemberChange} optionLabel="name" filter showClear filterBy="name" placeholder="Vyberte druhého člena" />
                </div>

                <PorovnaniDetail 
                    baseUrl={ this.props.baseUrl } apiBaseUrl={this.props.apiBaseUrl} firstMember={this.state.firstMember} secondMember={this.state.secondMember}
                />
                    
            </div>
        );
    }  
}

export default PorovnaniZastupitelu