import React from 'react'  
import axios from 'axios'
import LoadingPage from './LoadingPage'
import { Link } from "react-router-dom";
import { Divider } from 'primereact/divider';
import SVG from 'react-inlinesvg';

class Home extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            basicData : undefined
        }

        this.componentDidMount = this.componentDidMount.bind(this);
    }

    async componentDidMount() {
        await axios.get( this.props.apiBaseUrl + 'generalData').then((response) => {
            this.setState({basicData: response.data});
        });
    }

   generateSvg() {
        let x = 20;
        let y = [20, 55, 90, 125, 160];
        let content = '<svg width="390" height="200" xmlns="http://www.w3.org/2000/svg">';

        let idx = 0
        let colors = [];
        let idxs = this.state.basicData.nejnovejsi_zasedani.mandaty.map((party) => {
            idx = idx + party.pocet_mandatu;
            colors.push(party.strana_barva);
            // idx, na kterem se meni barva
            return idx;
        });
       
        let color= '';
        for (let i = 0; i < 55; i++ ) {
            if (i === 0) {
                color = colors[0];
            }
            if (idxs.includes(i)) {
                idx = idxs.indexOf(i);
                // meni se barva, tzn. je treba vzit tu nasledujici
                color = colors[idx+1];
            }
            if (i > 0 && i % 5 === 0) {
                x = x + 35;
            }
            content = content + '<ellipse ry="15" rx="15" cy="' + y[i%5] + '" cx="' + x + '" fill="' + color +'"/>';
        }
        content = content + '</svg>';
        return content.toString('base64');
    }
        
    render() {  
        const { basicData } = this.state;

        if (basicData !== undefined) {
            const leaderText = basicData['leader_pohlavi'] ? 'primátorka' : 'primátor';
            const svgData = this.generateSvg();

            const data = basicData['koalice'];
            const coalitionParties = basicData['koalice'].map((party, i, data) => {
                if (i + 1 === data.length) {
                    return party.strana_zkratka;
                } else {
                    return party.strana_zkratka + ', ';
                }
            }) 

            return ( 
                <div>
                    <div className="md:m-5 md:pt-7" style={{ minHeight: '25rem' }}>
                        <div className='grid grid-nogutter surface-0 text-800 p-5'>
                            <div className="col-12 xl:col-4 text-center xl:text-left flex align-items-center justify-content-center">
                                <section>
                                    <span className="text-6xl font-bold mb-1">Vizualizace hlasování Zastupitelstva města Brna </span>
                                    <span className="text-6xl text-primary font-bold mb-3 white-space-nowrap">({ basicData['funkcni_obdobi'] })</span>
                                </section>
                            </div>
                            <div className="col-12 mt-5 xl:mt-0 xl:col-8">
                                <div className='flex flex-column md:flex-row justify-content-center align-items-center'>
                                    <div>
                                        <SVG src={ svgData } />
                                    </div>
                                    <ul className="list-none mt-0 mb-0 xl:text-right">
                                    {
                                        basicData.nejnovejsi_zasedani.mandaty.map((party) => (
                                            <li key={party.strana_id} className='text-lg'>
                                                <Link
                                                    style={{ color: party.strana_barva, fontWeight: 600, fontSize: '1.5rem' }}
                                                    to={ `/strany/${party.strana_id}` }
                                                    key={ party.strana_id }
                                                    >
                                                    { party.strana_zkratka }
                                                </Link> – <span style={{ color: party.strana_barva, fontWeight: 600 }}>{ party.pocet_mandatu }</span>&nbsp;{ party.pocet_mandatu > 4 ?  'mandátů' :  'mandáty' }
                                            </li>
                                        ))
                                    }
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <Divider />

                    <div className="surface-0 text-center">
                        <div className="grid mt-5 mb-4">
                            <div className="col-12 md:col-6 lg:col-3 mt-4 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi bi-person-video text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['leader'] }</span>
                                    <div className="text-900 text-lg mt-2">{ leaderText } města Brna</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 md:mt-4 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi bi-calendar-check text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['pocet_zasedani'] }</span>
                                    <div className="text-900 text-lg mt-2">zasedání v zasedací síni Nové radnice</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 lg:mt-4 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi bi-stack text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['pocet_hlasovani'].toLocaleString('cz') }</span>
                                    <div className="text-900 text-lg mt-2">hlasování (tj. projednaných bodů)</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 lg:mt-4 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi pi-check-square text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['pocet_hlasovani_clenu'].toLocaleString('cz') }</span>
                                    <div className="text-900 text-lg mt-2">hlasů všech členů zastupitelstva</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi pi-users text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['koalice'].length }</span>
                                    <div className="text-900 text-lg mt-2">koaliční strany<br></br>({ coalitionParties })</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi pi-users text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['nejnovejsi_zasedani']['mandaty'].length }</span>
                                    <div className="text-900 text-lg mt-2">politických subjektů<br></br>({ basicData['celkem_stran'] }&nbsp;za celé období)</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi bi-gender-female text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['nejnovejsi_zasedani']['zastupitelky'] }</span>
                                    <div className="text-900 text-lg mt-2">zastupitelek<br></br>({ basicData['pocet_zastupitelek'] }&nbsp;za celé období)</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-6 lg:col-3 mb-4 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto', minHeight: '160px' }}>
                                    <i className="pi bi-gender-male text-2xl text-primary"></i>
                                    <span className='text-4xl text-primary font-semibold'>{ basicData['nejnovejsi_zasedani']['zastupitele'] }</span>
                                    <div className="text-900 text-lg mt-2">zastupitelů<br></br>({ basicData['pocet_zastupitelu'] }&nbsp;za celé období)</div>
                                </span>
                            </div>
                        </div>
                    </div>

                    <Divider />
                    
                    <div style={{ margin: "5rem 2rem" }}>
                        <p className='text-900 text-center'>Vizualizace a analýzy dat z&nbsp;hlasování členů zastupitelstva města Brna byly vytvořeny v&nbsp;rámci projektové praxe na FIT VUT ve spolupráci s&nbsp;magistrátem města Brna. Aplikace je nyní v&nbsp;<span className='font-semibold'>pilotním provozu</span>, pokud narazíte na jakoukoliv nesrovnalost nebo byste rádi poskytli zpětnou vazbu k&nbsp;projektu, napište, prosím, na <a href="mailto:zaklova@vutbr.cz" className='font-semibold'>zaklova@vutbr.cz</a> a/nebo <a href="mailto:data@brno.cz" className='font-semibold'>data@brno.cz</a>.</p>
                        <div className='flex flex-column mt-5 md:flex-row justify-content-center align-items-center'>
                            <a style={{ filter:'none'}} href="https://www.fit.vut.cz/" target='_blank' rel='noopener noreferrer'><img src={ this.props.baseUrl + `loga/logo_fit.png` } alt="logo_FIT" style={{ width:'350px'}} /></a>
                            <a style={{ filter:'none'}} href="https://www.brno.cz/" target='_blank' rel='noopener noreferrer'><img src={ this.props.baseUrl + `loga/Logo_Brno_RED_CMYK.png` } alt="logo_MMB" style={{ width:'350px'}} /></a>
                        </div>
                    </div>
                
                </div> 
            );
        } else {
            return (
                <LoadingPage />
            );   
        }  
    }  
}

export default Home  