import React from 'react'  
import axios from 'axios'
import LoadingPage from './LoadingPage'
import PollsTable from './PollsTable'
import { Divider } from 'primereact/divider';
import { Dropdown } from 'primereact/dropdown';
import { RadioButton } from 'primereact/radiobutton';
import { Checkbox } from 'primereact/checkbox';
import { InputText } from 'primereact/inputtext';


class Hlasovani extends React.Component {  
    constructor(props) {
        super(props);

        const searchParams = new URLSearchParams(window.location.search);

        this.sessionResults = [
            { name: 'přijato', code: 1 }, { name: 'nepřijato', code: 2 }
        ];

        this.voteResults = [
            { name: 'ano', code: 1 }, { name: 'ne', code: 2 }, { name: 'nehlasoval/a', code: 4 }, { name: 'nepřít.', code: 5 }, { name: 'zdržel/a se', code: 3 },
        ];

        this.members = [
            {name: "David Ale\u0161", code: 2}, {name: "V\u00edt Beran", code: 25}, {name: "Jana Bohu\u0148ovsk\u00e1", code: 33}, {name: "Petr Bo\u0159eck\u00fd", code: 3}, {name: "Anton\u00edn Crha", code: 26}, {name: "Krist\u00fdna \u010cern\u00e1 (roz. \u0160varcov\u00e1)", code: 56}, {name: "Ren\u00e9 \u010cern\u00fd", code: 4}, {name: "R\u00f3bert \u010cuma", code: 46}, {name: "Pavel Dvo\u0159\u00e1k", code: 5}, {name: "Ji\u0159\u00ed Falt\u00fdnek", code: 6}, {name: "Ivan Fencl", code: 52}, {name: "Marek Fi\u0161er", code: 47}, {name: "Mark\u00e9ta Gregorov\u00e1", code: 48}, {name: "David Grund", code: 34}, {name: "Ji\u0159\u00ed Herman", code: 35}, {name: "Petr Hlad\u00edk", code: 27}, {name: "Michal Chl\u00e1dek", code: 36}, {name: "Filip Chv\u00e1tal", code: 28}, {name: "Ji\u0159\u00ed Ides", code: 20}, {name: "Jitka Ivi\u010di\u010dov\u00e1", code: 29}, {name: "Marek Jan\u00ed\u010dek", code: 7}, {name: "Pavel Jank\u016fj", code: 37}, {name: "Kate\u0159ina Jaro\u0161ov\u00e1", code: 8}, {name: "Ludv\u00edk Kadlec", code: 38}, {name: "Karel Kalivoda", code: 9}, {name: "Jaroslav Kame\u0148", code: 59}, {name: "Karin Karasov\u00e1", code: 10}, {name: "Robert Kerndl", code: 39}, {name: "Ji\u0159\u00ed Kment", code: 53}, {name: "Tom\u00e1\u0161 Kol\u00e1\u010dn\u00fd", code: 49}, {name: "\u0160\u00e1rka Korke\u0161ov\u00e1", code: 11}, {name: "Ond\u0159ej Kotas", code: 50}, {name: "Petr Kratochv\u00edl", code: 40}, {name: "Iva Kremitovsk\u00e1", code: 12}, {name: "Filip Leder", code: 30}, {name: "Luk\u00e1\u0161 Mamula", code: 51}, {name: "Ji\u0159\u00ed Mihola", code: 31}, {name: "Richard Mr\u00e1zek", code: 13}, {name: "Ren\u00e9 Novotn\u00fd", code: 14}, {name: "Ji\u0159\u00ed Novotn\u00fd", code: 58}, {name: "Ji\u0159\u00ed Oliva", code: 21}, {name: "Alena Pavlasov\u00e1", code: 60}, {name: "Andrea Pazderov\u00e1", code: 41}, {name: "Lucie Pokorn\u00e1", code: 15}, {name: "David Pokorn\u00fd", code: 42}, {name: "Oliver Posp\u00ed\u0161il", code: 22}, {name: "V\u00edt Pr\u00fdgl", code: 16}, {name: "Martin P\u0159\u00edborsk\u00fd", code: 43}, {name: "Jana P\u0159ikrylov\u00e1", code: 54}, {name: "Pavel S\u00e1zavsk\u00fd", code: 23}, {name: "Petr Sou\u010dek", code: 17}, {name: "Monika Spilkov\u00e1", code: 57}, {name: "Pavel Stan\u011bk", code: 18}, {name: "Jaroslav Such\u00fd", code: 32}, {name: "Lucie \u0160afr\u00e1nkov\u00e1", code: 55}, {name: "David Trllo", code: 45}, {name: "Mark\u00e9ta Va\u0148kov\u00e1", code: 1}, {name: "Marek Viskot", code: 24}, {name: "Petr Vok\u0159\u00e1l", code: 19}
        ];

        this.parties = [
            {name: "ANO 2011", code: 2}, {name: "\u010cSSD", code: 3}, {name: "KDU-\u010cSL", code: 4}, {name: "Nez\u00e1visl\u00ed", code: 7}, {name: "Nez\u00e1visl\u00ed pro Brno", code: 8}, {name: "ODS", code: 1}, {name: "Pir\u00e1ti", code: 5}, {name: "SPD", code: 6}
        ];

        this.sessions = [
            {name: "Z8/01", code: 1}, {name: "Z8/02", code: 2}, {name: "Z8/03", code: 3}, {name: "Z8/04", code: 4}, {name: "Z8/05", code: 5}, {name: "Z8/06", code: 6}, {name: "Z8/07", code: 7}, {name: "Z8/08", code: 8}, {name: "Z8/09", code: 9}, {name: "Z8/10", code: 10}, {name: "Z8/11", code: 11}, {name: "Z8/12", code: 12}, {name: "Z8/13", code: 13}, {name: "Z8/14", code: 14}, {name: "Z8/15", code: 15}, {name: "Z8/16", code: 16}, {name: "Z8/17", code: 17}, {name: "Z8/18", code: 18}, {name: "Z8/19", code: 19}, {name: "Z8/20", code: 20}, {name: "Z8/21", code: 21}, {name: "Z8/22", code: 22}, {name: "Z8/23", code: 23}, {name: "Z8/24", code: 24}, {name: "Z8/25", code: 25}, {name: "Z8/26", code: 26}, {name: "Z8/27", code: 27}, {name: "Z8/28", code: 28}, {name: "Z8/29", code: 29}, {name: "Z8/30", code: 30}, {name: "Z8/31", code: 31}, {name: "Z8/32", code: 32}, {name: "Z8/33", code: 33}, {name: "Z8/34", code: 34}, {name: "Z8/35", code: 35}, {name: "Z8/36", code: 36}, {name: "Z8/37", code: 37}, {name: "Z8/38", code: 38}, {name: "Z8/39", code: 39}, {name: "Z8/40", code: 40}
        ];

        let sessionResultValue = searchParams.get("vysledek_hlasovani") || null;
        let voteResultValue = searchParams.get("vysledek_volice") || null;
        let memberValue = searchParams.get("clen") || null;
        let partyValue = searchParams.get("strana") || null;
        let sessionValue = searchParams.get("zasedani") || null;
        
        this.state = {
            votesData : undefined,
            checked: (searchParams.get("pouze_platna") === 'true') || null,
            input: searchParams.get("text") || '',
            view: searchParams.get("pohled") || null,
            sessionResult: sessionResultValue !== null ? this.sessionResults.find(element => element.code === parseInt(sessionResultValue)) : null,
            voteResult: voteResultValue !== null ? this.voteResults.find(element => element.code === parseInt(voteResultValue)) : null,
            member: memberValue !== null ? this.members.find(element => element.code === parseInt(memberValue)) : null,
            party: partyValue !== null ? this.parties.find(element => element.code === parseInt(partyValue)) : null,
            session: sessionValue !== null ? this.sessions.find(element => element.code === parseInt(sessionValue)) : null
        }

        this.componentDidMount = this.componentDidMount.bind(this);

        this.onInputChange = this.onInputChange.bind(this);
        this.onViewChange = this.onViewChange.bind(this);
        this.onValidChange = this.onValidChange.bind(this);
        this.onSessionResultChange = this.onSessionResultChange.bind(this);
        this.onVoteResultChange = this.onVoteResultChange.bind(this);
        this.onMemberChange = this.onMemberChange.bind(this);
        this.onPartyChange = this.onPartyChange.bind(this);
        this.onSessionChange = this.onSessionChange.bind(this);
    }

    setParams(key, value) {
        const url = new URL(window.location);
        if (key === 'pohled') {
            // uklid v URL
            url.searchParams.delete('text');
            url.searchParams.delete('vysledek_hlasovani');
            url.searchParams.delete('vysledek_volice');
            url.searchParams.delete('pouze_platna');
            url.searchParams.delete('clen');
            url.searchParams.delete('strana');
            url.searchParams.delete('zasedani');

            // uklid vnitrnich stavu
            this.setState({ input: '' });
            this.setState({ sessionResult: null });
            this.setState({ voteResult: null });
            this.setState({ checked: null });
            this.setState({ member: null });
            this.setState({ party: null });
            this.setState({ session: null });
        }
        url.searchParams.set(key, value);
        window.history.pushState({}, '', url);
    }
    
    onInputChange(e) {
        this.setState({input: e.target.value});
        if (e.target.value !== '') {
            // vse ok
            this.setParams('text', e.target.value);
        } else {
            // zruseni filtru
            const url = new URL(window.location);
            url.searchParams.delete('text');
            window.history.pushState({}, '', url);  
        }
    }

    onViewChange(e) {
        this.setState({view: e.value});
        this.setParams('pohled', e.value);
    }

    onValidChange(e) {
        this.setState({ checked: e.checked });
        if (e.checked === true) {
            this.setParams('pouze_platna', e.checked);
        } else {
            // zruseni filtru
            const url = new URL(window.location);
            url.searchParams.delete('pouze_platna');
            window.history.pushState({}, '', url);
        }
    }

    onSessionResultChange(e) {
        this.setState({ sessionResult: e.value });
        this.setParams('vysledek_hlasovani', e.value.code);
    }

    onVoteResultChange(e) {
        this.setState({ voteResult: e.value });
        this.setParams('vysledek_volice', e.value.code);
    }

    onPartyChange(e) {
        this.setState({ party: e.value });
        this.setParams('strana', e.value.code);
    }

    onMemberChange(e) {
        this.setState({ member: e.value });
        if (e.value !== undefined) {
            // vse ok
            this.setParams('clen', e.value.code);
        } else {
            // zruseni filtru
            this.setState({ voteResult: null });
            this.setState({ checked: null });

            const url = new URL(window.location);
            url.searchParams.delete('clen');
            url.searchParams.delete('vysledek_volice');
            url.searchParams.delete('pouze_platna');
            window.history.pushState({}, '', url);  
        }
    }

    onSessionChange(e) {
        this.setState({ session: e.value });
        if (e.value !== undefined) {
            // vse ok
            this.setParams('zasedani', e.value.code);
        } else {
            // zruseni filtru
            this.setState({ sessionResult: null });
            this.setState({ checked: null });

            const url = new URL(window.location);
            url.searchParams.delete('zasedani');
            url.searchParams.delete('vysledek_hlasovani');
            url.searchParams.delete('pouze_platna');
            window.history.pushState({}, '', url);  
        }
    }

    async componentDidMount() {
        if ( this.state.votesData === undefined ){
            await axios.get( this.props.apiBaseUrl + 'votesData').then((response) => {
                this.setState({ votesData: response.data });
            });
        }
    }
    
    render() {
        const { votesData } = this.state;
        const { baseUrl } = this.props;

        if (votesData !== undefined && baseUrl !== undefined) {
            return (
                <div>
                    <div className='m-5 mt-0 mb-0'>
                        <h1 className='text-primary'>Sumarizace hlasování</h1>
                    </div>

                    <div className="surface-0 text-center">
                        <div className="grid">
                            <div className="col-12 md:col-3 mt-3 mb-3 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto' }}>
                                    <i className="pi bi-stack text-2xl text-primary"></i>
                                    <span className='text-2xl text-primary font-semibold'>{ votesData.pocet_hlasovani.toLocaleString('cz') }</span>
                                    <div className="text-900 text-lg mt-2">hlasování</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-3 mt-3 mb-3 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto' }}>
                                    <i className="pi bi-check-square text-2xl text-primary"></i>
                                    <span className='text-2xl text-primary font-semibold'>{ votesData.pocet_prijatych.toLocaleString('cz') }</span>
                                    <div className="text-900 text-lg mt-2">přijatých návrhů</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-3 mt-3 mb-3 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto' }}>
                                    <i className="pi bi-x-square text-2xl text-primary"></i>
                                    <span className='text-2xl text-primary font-semibold'>{ votesData.pocet_neprijatych }</span>
                                    <div className="text-900 text-lg mt-2">nepřijatých návrhů</div>
                                </span>
                            </div>
                            <div className="col-12 md:col-3 mt-3 mb-3 px-5">
                                <span className="p-3 shadow-2 mb-3 flex flex-column justify-content-center" style={{ borderRadius: '10px', width: '90%', margin: 'auto' }}>
                                    <i className="pi bi-question-square text-2xl text-primary"></i>
                                    <span className='text-2xl text-primary font-semibold'>{ votesData.pocet_neplatnych }</span>
                                    <div className="text-900 text-lg mt-2">neplatných hlasování</div>
                                </span>
                            </div>
                        </div>
                    </div>
 
                    <Divider />

                    <div className='m-5'>
                        <h2 className='text-primary mt-5'>Jednotlivá hlasování</h2> 

                        <div className='filterMenu mb-3 flex flex-column md:flex-row lg:justify-content-between'>
                            <div className='flex flex-column lg:flex-row'>
                                <div className="field-radiobutton m-2 lg:ml-0">
                                    <RadioButton inputId="view1" name="view" value="zasedani" onChange={this.onViewChange} checked={this.state.view === 'zasedani'} />
                                    <label htmlFor="view1">Zasedání</label>
                                </div>
                                <div className="field-radiobutton m-2">
                                    <RadioButton inputId="view2" name="view" value="strana" onChange={this.onViewChange} checked={this.state.view === 'strana'} />
                                    <label htmlFor="view2">Strana</label>
                                </div>
                                <div className="field-radiobutton m-2">
                                    <RadioButton inputId="view3" name="view" value="clen" onChange={this.onViewChange} checked={this.state.view === 'clen'} />
                                    <label htmlFor="view3">Člen/ka zastupitelstva</label>
                                </div>
                                <div className="field-radiobutton m-2 ">
                                    <RadioButton inputId="view4" name="view" value="text" onChange={this.onViewChange} checked={this.state.view === 'text'} />
                                    <label htmlFor="view4">Hledaný text v předmětech hlasování</label>
                                </div>
                            </div>
                            <div className='flex flex-column lg:flex-row justify-content-center lg:align-items-center ml-5 lg:ml-0 mt-5 lg:mt-0'>
                                <div className={'mr-3 mb-2 ' + (this.state.view === 'zasedani' ? 'block' : 'hidden')}>
                                    <Dropdown value={this.state.session} options={this.sessions} onChange={this.onSessionChange} optionLabel="name" filter showClear filterBy="name" placeholder="Vyberte zasedání" />
                                </div>
                                <div className={'mr-3 mb-2 ' + (this.state.view === 'clen' ? 'block' : 'hidden')}>
                                    <Dropdown value={this.state.member} options={this.members} onChange={this.onMemberChange} optionLabel="name" filter showClear filterBy="name" placeholder="Vyberte člena" />
                                </div>
                                <div className={'mr-3 mb-2 ' + (this.state.view === 'strana' ? 'block' : 'hidden')}>
                                    <Dropdown value={this.state.party} options={this.parties} onChange={this.onPartyChange} optionLabel="name" placeholder="Vyberte stranu" />
                                </div>
                                <div className={'mr-3 mb-2 ' + (this.state.view === 'zasedani' || this.state.view === 'strana'? 'block' : 'hidden')}>
                                    <Dropdown value={this.state.sessionResult} options={this.sessionResults} onChange={this.onSessionResultChange} optionLabel="name" placeholder="Vyberte výsledek" />
                                </div>
                                <div className={'mr-3 mb-2 ' + (this.state.view === 'strana' || this.state.view === 'clen' ? 'block' : 'hidden')}>
                                    <Dropdown value={this.state.voteResult} options={this.voteResults} onChange={this.onVoteResultChange} optionLabel="name" placeholder="Vyberte možnost" />
                                </div>
                                <div className={'mr-3 ' + (this.state.view === 'text' ? 'block' : 'hidden')}>
                                    <span className="p-input-icon-left">
                                        <i className="pi pi-search" />
                                        <InputText value={this.state.input || ''} onChange={this.onInputChange} placeholder="Napište hledaný text" />
                                    </span>
                                </div>
                                <div className={'field-checkbox mt-3 mb-3 mr-3 ' + (this.state.view === 'zasedani' ||this.state.view === 'strana' || this.state.view === 'clen' ? 'block' : 'hidden')}>
                                    <Checkbox inputId="binary" checked={this.state.checked} onChange={this.onValidChange} />
                                    <label htmlFor="binary">Pouze platná hlasování</label>
                                </div>
                            </div>
                        </div>

                    
                        <PollsTable 
                            baseUrl={ baseUrl } apiBaseUrl={this.props.apiBaseUrl} text={this.state.input} checked={this.state.checked} view={this.state.view} 
                            sessionResult={this.state.sessionResult} voteResult={this.state.voteResult} member={this.state.member}
                            party={this.state.party} session={this.state.session}
                        />
                    </div>
                </div>
            );
        } else {
            return (
                <LoadingPage />
            );   
        }
    }
}

export default Hlasovani
