import React from 'react'  
import axios from 'axios'
import LoadingPage from './LoadingPage'
import { Link } from "react-router-dom";

class DochazkaZastupitelu extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            basicData : undefined
        }

        this.componentDidMount = this.componentDidMount.bind(this);
    }

    async componentDidMount() {
        await axios.get( this.props.apiBaseUrl + 'attendanceDashboard').then((response) => {
            this.setState({basicData: response.data});
        });
    }

    render() {  
        const { basicData } = this.state;

        if (basicData !== undefined) {
            
            return ( 
                <div className="m-5 mt-0">
                    <div>
                        <h1 className='text-primary'>Analýzy: docházka zastupitelů v&nbsp;%</h1> 
                        <p>
                            Ve funkčním obobí 8.&nbsp;zastupitelstva působilo celkem <b>60</b> zastupitelů, někteří tedy byly aktivní pouze část tohoto období. 
                            Aktivní zastupitelé jsou zobrazeni pod svou aktuální politickou stranou.
                        </p>
                        <p>
                            Jelikož mohou zastupitelé během zasedání odcházet a&nbsp;zase se vracet, je jejich docházka vypočtena jako poměr platných hlasování, u nichž byl 
                            zastupitel/ka přitomen/přítomna, a&nbsp;všech platných hlasování. Rovněž je ve výpočtu zohledněno, že zastupitelé měli různě dlouhá funkční období.
                        </p>
                    </div>

                    {basicData.map((party) => (
                        <div key={ party.strana_id + 'strana' } className="surface-0 p-4 shadow-2 border-round mt-5">
                            <div className='flex flex-column'>
                                <h2 className='ml-2 mt-0'>
                                    <Link 
                                        style={{ color: party.strana_barva }}
                                        to={`/strany/${ party.strana_id }`}
                                        key={party.strana_id}>
                                            { party.strana_zkratka }
                                    </Link>
                                </h2>
                                <ul className="homeUl grid mt-2">
                                {party.clenove.map((clen) => (
                                    <li key={ clen.id } className='col-12 md:col-6 lg:col-4 xl:col-3 font-semibold'>
                                    {
                                        clen.aktivni === 1 
                                        ?
                                        <Link
                                            style={{ color: '#6366F1' }}
                                            to={`/zastupitele/${clen.id}`}
                                            key={clen.id}
                                            >
                                            {clen.jmeno}
                                        </Link>
                                        :
                                        <Link
                                            style={{ color: '#9E9E9E' }}
                                            to={`/zastupitele/${clen.id}`}
                                            key={clen.id}
                                            >
                                            {clen.jmeno}
                                        </Link> 
                                    } – {clen.dochazka} %
                                </li>
                                ))}
                                </ul>
                            </div>
                        </div>
                    ))}

                </div>
            );
        } else {
            return (
                <LoadingPage />
            );   
        }  
    }  
}

export default DochazkaZastupitelu  