import React, { Component } from 'react';
import { Outlet, Link } from "react-router-dom";
import axios from 'axios'
import LoadingPage from './LoadingPage'
import { Divider } from 'primereact/divider';

class App extends React.Component {  
    constructor(props) {
        super(props);

        this.state = {
            activeIndex: 0,
            basicData : undefined,
            width: 0,
            height: 0,
            isShown: false
        }

        this.navItems = [
            {label: 'Úvod', icon: 'pi pi-fw pi-home', to: '/'},
            {label: 'Strany', icon: 'pi pi-fw pi-users', to: '/strany'},
            {label: 'Zastupitelé', icon: 'pi pi-fw pi-user', to: '/zastupitele'},
            {label: 'Zasedání', icon: 'pi pi-fw pi-book', to: '/zasedani'},
            {label: 'Hlasování', icon: 'pi pi-fw pi-check-square', to: '/hlasovani'},
            {label: 'Analýzy', icon: 'pi pi-fw pi-chart-line', to: '/analyzy'},
        ];

        this.componentDidMount = this.componentDidMount.bind(this);
        this.showHide = this.showHide.bind(this);
        this.hideMenu = this.hideMenu.bind(this);
    }

    async componentDidMount() {
        await axios.get( this.props.apiBaseUrl + 'generalData').then((response) => {
            this.setState({basicData: response.data});
        });
        window.addEventListener('resize', this.updateDimensions);
    }

    hideMenu = () => {
        if (window.innerWidth <= 700) {
            const elemNav = document.getElementById('navbar');
            this.setState({isShown: false});
            elemNav.style.display = 'none';
        }
    }

    updateDimensions = () => {
        let actHeight = window.innerHeight;
        let prevWidth = this.state.width;
        let newWidth = window.innerWidth;

        this.setState({ width: newWidth, height: actHeight });
        const elemNav = document.getElementById('navbar');
        if (newWidth > 700 && elemNav.style.display === 'none') {
            elemNav.style.display = 'flex';
        };
        if (newWidth <= 700 && prevWidth > 700) {
            elemNav.style.display = 'none';
        };
    }

    componentWillUnmount(){
        window.removeEventListener('resize', this.updateDimensions);
    }

    showHide() {
        const elemNav = document.getElementById('navbar');
        if (this.state.isShown === true) {
            this.setState({isShown: false});
            elemNav.style.display = 'none';
        } else {
            this.setState({isShown: true});
            elemNav.style.display = 'flex';
        }
    }

    render() {
        const { basicData } = this.state;

        if (basicData !== undefined) {
            return (
                <div className='ml-5 mr-5'>
                    <div className='sticky lg:static top-0 bg-white z-1'>
                        <button id='more' onClick={this.showHide}><span className='pi pi-bars p-menuitem-icon'></span></button>
                        <nav id='navbar' className='text-center'>
                            {this.navItems.map((item) => (
                                <Link
                                to={`${item.to}`}
                                key={item.label}
                                onClick={this.hideMenu}
                                >
                                    <span className={`mr-1 p-menuitem-icon ${item.icon}`}></span>
                                    <span className="p-menuitem-text">{item.label}</span>
                                </Link>
                            ))}
                        </nav>
                        <Divider style={{ margin: 0 }}/>
                    </div>
                    <div>
                        <div id='body'>
                            <Outlet />
                        </div>
                        <footer id='footer' className='mt-5'>
                            <div className='flex justify-content-between flex-wrap card-container purple-container ml-5 mr-5'>
                                <Divider style={{ margin: 0 }}/>
                                <p className='text-500 line-height-3'>&copy; 2022 Kristýna Zaklová</p>
                                <p className='text-500 line-height-3'>Proměnlivá data jsou platná k poslednímu zasedání, tj. Z8/{ basicData.nejnovejsi_zasedani.cislo } ze dne { basicData['nejnovejsi_zasedani']['datum'] }</p>
                            </div>
                        </footer>
                    </div>
                </div>
            );
        } else {
            return (
                <LoadingPage />
            );   
        }
    }
}

export default App;
