import React from 'react'  
import { Link } from "react-router-dom";

class Analyzy extends React.Component {  
    constructor(props) {
        super(props);

        this.analysesOptions = [
            { name: 'Docházka zastupitelů', code: 'dochazka_zastupitelu' },
            { name: 'Porovnání zastupitelů', code: 'porovnani_zastupitelu' },
        ];
    }

    onOptionChange(e) {
        this.setState({ analysisOption: e.value });
        let url = String(window.location).split("/analyzy");
        window.location.href = url[0] + '/analyzy/' + e.value.code;
    }
        
    render() {  
        
        return ( 
            <div className="m-5 mt-0">
                <div>
                    <h1 className='text-primary'>Analýzy</h1> 
                    <p>Z dostupných dat byly vytvořeny následující analýzy. Postupně bude jejich počet rozšiřován.</p>
                    <ul className='pageUl mt-2'>
                        {this.analysesOptions.map((analysis) => (
                            <li key={ analysis.code } className='font-semibold'>
                                <Link
                                    style={{ color: '#6366F1' }}
                                    to={analysis.code}
                                    key={analysis.code}
                                    >
                                    {analysis.name}
                                </Link>
                            </li>
                        ))}
                    </ul>
                </div>
            </div>
        );
    }  
}

export default Analyzy  