-- phpMyAdmin SQL Dump
-- version 4.9.2
-- https://www.phpmyadmin.net/
--
-- Počítač: 127.0.0.1:3308
-- Vytvořeno: Sob 22. říj 2022, 18:38
-- Verze serveru: 8.0.18
-- Verze PHP: 7.3.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Databáze: `zmb_hlasovani`
--

-- --------------------------------------------------------

--
-- Struktura tabulky `clen_zmb`
--

DROP TABLE IF EXISTS `clen_zmb`;
CREATE TABLE IF NOT EXISTS `clen_zmb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmeno_clena` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `prijmeni_clena` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `pohlavi` tinyint(1) DEFAULT NULL,
  `foto` varchar(50) COLLATE utf8_czech_ci DEFAULT NULL,
  `zdroj` varchar(500) COLLATE utf8_czech_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `clen_zmb`
--

INSERT INTO `clen_zmb` (`id`, `jmeno_clena`, `prijmeni_clena`, `pohlavi`, `foto`, `zdroj`) VALUES
(1, 'Markéta', 'Vaňková', 1, 'vankova.jpg', 'https://g.denik.cz/50/bb/marketa-vankova_denik-630.jpg');

-- --------------------------------------------------------

--
-- Struktura tabulky `hlasovani`
--

DROP TABLE IF EXISTS `hlasovani`;
CREATE TABLE IF NOT EXISTS `hlasovani` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jmeno_souboru` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `validni_hlasovani` tinyint(1) NOT NULL,
  `ck_poradi_ZMB` int(11) NOT NULL,
  `cislo_zasedani` int(11) NOT NULL,
  `cislo_hlasovani` int(11) NOT NULL,
  `cas` time NOT NULL,
  `predmet_hlasovani` varchar(500) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `ck_vysledek_hlasovani` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck__poradi__ZMB` (`ck_poradi_ZMB`),
  KEY `ck_vysledek_hlasovani` (`ck_vysledek_hlasovani`),
  KEY `ck_poradi_zasedani` (`cislo_zasedani`)
) ENGINE=InnoDB AUTO_INCREMENT=3923 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `hlasovani_clena`
--

DROP TABLE IF EXISTS `hlasovani_clena`;
CREATE TABLE IF NOT EXISTS `hlasovani_clena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_cislo_hlasovani` int(11) NOT NULL,
  `ck_clen_ZMB` int(11) NOT NULL,
  `ck_vysledek_volice` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck_cislo_hlasovani` (`ck_cislo_hlasovani`),
  KEY `ck_clen_ZMB` (`ck_clen_ZMB`),
  KEY `ck_vysledek_volice` (`ck_vysledek_volice`)
) ENGINE=InnoDB AUTO_INCREMENT=215711 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `hlasovani_obsahuje_slovo`
--

DROP TABLE IF EXISTS `hlasovani_obsahuje_slovo`;
CREATE TABLE IF NOT EXISTS `hlasovani_obsahuje_slovo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_hlasovani` int(11) NOT NULL,
  `ck_klicove_slovo` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck__klicove_slovo` (`ck_klicove_slovo`),
  KEY `ck__hlasovani` (`ck_hlasovani`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `klicove_slovo`
--

DROP TABLE IF EXISTS `klicove_slovo`;
CREATE TABLE IF NOT EXISTS `klicove_slovo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `koalice`
--

DROP TABLE IF EXISTS `koalice`;
CREATE TABLE IF NOT EXISTS `koalice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_poradi_ZMB` int(11) NOT NULL,
  `ck_politicka_strana` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck____poradi___ZMB` (`ck_poradi_ZMB`),
  KEY `ck___politicka__strana` (`ck_politicka_strana`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `koalice`
--

INSERT INTO `koalice` (`id`, `ck_poradi_ZMB`, `ck_politicka_strana`) VALUES
(1, 8, 1),
(2, 8, 4),
(3, 8, 5),
(4, 8, 3);

-- --------------------------------------------------------

--
-- Struktura tabulky `oblast`
--

DROP TABLE IF EXISTS `oblast`;
CREATE TABLE IF NOT EXISTS `oblast` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `oblast`
--

INSERT INTO `oblast` (`id`, `text`) VALUES
(1, 'doprava'),
(2, 'územní plánování, rozvoj a veřejné prostranství'),
(3, 'bydlení'),
(4, 'životní prostředí'),
(5, 'školství'),
(6, 'sport'),
(7, 'kultura'),
(8, 'bezpečnost'),
(9, 'sociální oblast'),
(10, 'zdavotnictví'),
(11, 'rodinná politika'),
(12, 'investice'),
(13, 'majetek'),
(14, 'marketing a cestovní ruch'),
(15, 'otevřené a participující město'),
(16, 'informační technologie'),
(17, 'chytré město');

-- --------------------------------------------------------

--
-- Struktura tabulky `politicka_strana`
--

DROP TABLE IF EXISTS `politicka_strana`;
CREATE TABLE IF NOT EXISTS `politicka_strana` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zkratka` varchar(20) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `nazev` varchar(150) CHARACTER SET utf8 COLLATE utf8_czech_ci DEFAULT NULL,
  `barva` varchar(10) COLLATE utf8_czech_ci DEFAULT NULL,
  `logo` varchar(50) COLLATE utf8_czech_ci DEFAULT NULL,
  `zdroj` varchar(500) COLLATE utf8_czech_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `politicka_strana`
--

INSERT INTO `politicka_strana` (`id`, `zkratka`, `nazev`, `barva`, `logo`, `zdroj`) VALUES
(1, 'ODS', 'Občanská demokratická strana', '#004494', 'ods.svg', 'https://commons.wikimedia.org/wiki/File:ODS_vlajka_logotyp.svg'),
(2, 'ANO 2011', NULL, '#261060', 'ano.svg', NULL),
(3, 'ČSSD', 'Česká strana sociálně demokratická', '#F07D00', 'cssd.svg', NULL),
(4, 'KDU-ČSL', 'Křesťanská a demokratická unie – Československá strana lidová', '#E6AC21', 'kdu-csl.svg', NULL),
(5, 'Piráti', 'Česká pirátská strana', '#000000', 'pirati.jpg', 'https://commons.wikimedia.org/wiki/File:Pirati_-_logotyp.jpg'),
(6, 'SPD', 'Svoboda a přímá demokracie', '#EA2329', 'spd.svg', NULL),
(7, 'Nezávislí', NULL, '#95CD55', NULL, NULL),
(8, 'Nezávislí pro Brno', NULL, '#784CB7', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktura tabulky `predvolebni_slib`
--

DROP TABLE IF EXISTS `predvolebni_slib`;
CREATE TABLE IF NOT EXISTS `predvolebni_slib` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_poradi_ZMB` int(11) NOT NULL,
  `ck_oblast` int(11) NOT NULL,
  `slib` varchar(500) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `ck_zdroj` int(11) NOT NULL,
  `zdroj_url` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ck_poradi__ZMB` (`ck_poradi_ZMB`),
  KEY `ck_oblast` (`ck_oblast`),
  KEY `ck_zdroj` (`ck_zdroj`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `prislusi_k`
--

DROP TABLE IF EXISTS `prislusi_k`;
CREATE TABLE IF NOT EXISTS `prislusi_k` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_poradi_ZMB` int(11) NOT NULL,
  `ck_clen_ZMB` int(11) NOT NULL,
  `ck_politicka_strana` int(11) NOT NULL,
  `datum_od` date NOT NULL,
  `datum_do` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck__clen__ZMB` (`ck_clen_ZMB`),
  KEY `ck__politicka__strana` (`ck_politicka_strana`),
  KEY `ck___poradi___ZMB` (`ck_poradi_ZMB`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `slibila`
--

DROP TABLE IF EXISTS `slibila`;
CREATE TABLE IF NOT EXISTS `slibila` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_slib` int(11) NOT NULL,
  `ck_politicka_strana` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck__slib` (`ck_slib`),
  KEY `ck__politicka_strana` (`ck_politicka_strana`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `slib_obsahuje_slovo`
--

DROP TABLE IF EXISTS `slib_obsahuje_slovo`;
CREATE TABLE IF NOT EXISTS `slib_obsahuje_slovo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_slib` int(11) NOT NULL,
  `ck_klicove_slovo` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck_slib` (`ck_slib`),
  KEY `ck_klicove_slovo` (`ck_klicove_slovo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `statistika_hlasovani`
--

DROP TABLE IF EXISTS `statistika_hlasovani`;
CREATE TABLE IF NOT EXISTS `statistika_hlasovani` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_hlasovani` int(11) NOT NULL,
  `pocet_ano` int(11) NOT NULL,
  `pocet_ne` int(11) NOT NULL,
  `zdrzelo_se` int(11) NOT NULL,
  `nehlasovalo` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ck_hlasovani` (`ck_hlasovani`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `vysledek_hlasovani`
--

DROP TABLE IF EXISTS `vysledek_hlasovani`;
CREATE TABLE IF NOT EXISTS `vysledek_hlasovani` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `vysledek_hlasovani`
--

INSERT INTO `vysledek_hlasovani` (`id`, `text`) VALUES
(1, 'Přijato'),
(2, 'Nepřijato');

-- --------------------------------------------------------

--
-- Struktura tabulky `vysledek_volice`
--

DROP TABLE IF EXISTS `vysledek_volice`;
CREATE TABLE IF NOT EXISTS `vysledek_volice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `vysledek_volice`
--

INSERT INTO `vysledek_volice` (`id`, `text`) VALUES
(1, 'Ano'),
(2, 'Ne');

-- --------------------------------------------------------

--
-- Struktura tabulky `zasedani_zmb`
--

DROP TABLE IF EXISTS `zasedani_zmb`;
CREATE TABLE IF NOT EXISTS `zasedani_zmb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ck_poradi_ZMB` int(11) NOT NULL,
  `cislo_zasedani` int(11) NOT NULL,
  `datum_zasedani` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck___poradi__ZMB` (`ck_poradi_ZMB`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `zasedani_zmb_video`
--

DROP TABLE IF EXISTS `zasedani_zmb_video`;
CREATE TABLE IF NOT EXISTS `zasedani_zmb_video` (
  `id` int(11) NOT NULL,
  `ck_zasedani_zmb` int(11) NOT NULL,
  `url` varchar(500) COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ck_zasedani_zmb` (`ck_zasedani_zmb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `zdroj`
--

DROP TABLE IF EXISTS `zdroj`;
CREATE TABLE IF NOT EXISTS `zdroj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `zdroj`
--

INSERT INTO `zdroj` (`id`, `text`) VALUES
(1, 'koaliční smlouva');

-- --------------------------------------------------------

--
-- Struktura tabulky `zmb`
--

DROP TABLE IF EXISTS `zmb`;
CREATE TABLE IF NOT EXISTS `zmb` (
  `poradi_ZMB` int(11) NOT NULL AUTO_INCREMENT,
  `ck_leader` int(11) DEFAULT NULL,
  `funkcni_obdobi_od` year(4) NOT NULL,
  `funkcni_obdobi_do` year(4) NOT NULL,
  PRIMARY KEY (`poradi_ZMB`),
  KEY `ck_leader` (`ck_leader`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Vypisuji data pro tabulku `zmb`
--

INSERT INTO `zmb` (`poradi_ZMB`, `ck_leader`, `funkcni_obdobi_od`, `funkcni_obdobi_do`) VALUES
(7, NULL, 2014, 2018),
(8, 1, 2018, 2022),
(9, NULL, 2022, 2026);

-- --------------------------------------------------------

--
-- Struktura tabulky `_attendancestats`
--

DROP TABLE IF EXISTS `_attendancestats`;
CREATE TABLE IF NOT EXISTS `_attendancestats` (
  `poradi_zmb` int(11) NOT NULL AUTO_INCREMENT,
  `ucast` int(11) NOT NULL,
  PRIMARY KEY (`poradi_zmb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `_attendancestatsdetailed`
--

DROP TABLE IF EXISTS `_attendancestatsdetailed`;
CREATE TABLE IF NOT EXISTS `_attendancestatsdetailed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `poradi_ZMB` int(11) NOT NULL,
  `strana_id` int(11) NOT NULL,
  `strana_zkratka` varchar(20) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `strana_barva` varchar(10) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `clen_ZMB_id` int(11) NOT NULL,
  `clen_ZMB` varchar(200) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  `dochazka` varchar(30) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

-- --------------------------------------------------------

--
-- Struktura tabulky `_partiesstats`
--

DROP TABLE IF EXISTS `_partiesstats`;
CREATE TABLE IF NOT EXISTS `_partiesstats` (
  `ck_politicka_strana` int(11) NOT NULL,
  `modifiedText` varchar(50) COLLATE utf8_czech_ci NOT NULL,
  `sum` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_czech_ci;

--
-- Omezení pro exportované tabulky
--

--
-- Omezení pro tabulku `hlasovani`
--
ALTER TABLE `hlasovani`
  ADD CONSTRAINT `ck__poradi__ZMB` FOREIGN KEY (`ck_poradi_ZMB`) REFERENCES `zmb` (`poradi_ZMB`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_poradi_zasedani` FOREIGN KEY (`cislo_zasedani`) REFERENCES `zasedani_zmb` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_vysledek_hlasovani` FOREIGN KEY (`ck_vysledek_hlasovani`) REFERENCES `vysledek_hlasovani` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `hlasovani_clena`
--
ALTER TABLE `hlasovani_clena`
  ADD CONSTRAINT `ck_cislo_hlasovani` FOREIGN KEY (`ck_cislo_hlasovani`) REFERENCES `hlasovani` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_clen_ZMB` FOREIGN KEY (`ck_clen_ZMB`) REFERENCES `clen_zmb` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_vysledek_volice` FOREIGN KEY (`ck_vysledek_volice`) REFERENCES `vysledek_volice` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `hlasovani_obsahuje_slovo`
--
ALTER TABLE `hlasovani_obsahuje_slovo`
  ADD CONSTRAINT `ck__hlasovani` FOREIGN KEY (`ck_hlasovani`) REFERENCES `hlasovani` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck__klicove_slovo` FOREIGN KEY (`ck_klicove_slovo`) REFERENCES `klicove_slovo` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `koalice`
--
ALTER TABLE `koalice`
  ADD CONSTRAINT `ck____poradi___ZMB` FOREIGN KEY (`ck_poradi_ZMB`) REFERENCES `zmb` (`poradi_ZMB`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck___politicka__strana` FOREIGN KEY (`ck_politicka_strana`) REFERENCES `politicka_strana` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `predvolebni_slib`
--
ALTER TABLE `predvolebni_slib`
  ADD CONSTRAINT `ck_oblast` FOREIGN KEY (`ck_oblast`) REFERENCES `oblast` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_poradi__ZMB` FOREIGN KEY (`ck_poradi_ZMB`) REFERENCES `zmb` (`poradi_ZMB`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_zdroj` FOREIGN KEY (`ck_zdroj`) REFERENCES `zdroj` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `prislusi_k`
--
ALTER TABLE `prislusi_k`
  ADD CONSTRAINT `ck___poradi___ZMB` FOREIGN KEY (`ck_poradi_ZMB`) REFERENCES `zmb` (`poradi_ZMB`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck__clen__ZMB` FOREIGN KEY (`ck_clen_ZMB`) REFERENCES `clen_zmb` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck__politicka__strana` FOREIGN KEY (`ck_politicka_strana`) REFERENCES `politicka_strana` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `slibila`
--
ALTER TABLE `slibila`
  ADD CONSTRAINT `ck__politicka_strana` FOREIGN KEY (`ck_politicka_strana`) REFERENCES `politicka_strana` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck__slib` FOREIGN KEY (`ck_slib`) REFERENCES `predvolebni_slib` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `slib_obsahuje_slovo`
--
ALTER TABLE `slib_obsahuje_slovo`
  ADD CONSTRAINT `ck_klicove_slovo` FOREIGN KEY (`ck_klicove_slovo`) REFERENCES `klicove_slovo` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `ck_slib` FOREIGN KEY (`ck_slib`) REFERENCES `predvolebni_slib` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `statistika_hlasovani`
--
ALTER TABLE `statistika_hlasovani`
  ADD CONSTRAINT `ck_hlasovani` FOREIGN KEY (`ck_hlasovani`) REFERENCES `hlasovani` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `zasedani_zmb`
--
ALTER TABLE `zasedani_zmb`
  ADD CONSTRAINT `ck___poradi__ZMB` FOREIGN KEY (`ck_poradi_ZMB`) REFERENCES `zmb` (`poradi_ZMB`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `zasedani_zmb_video`
--
ALTER TABLE `zasedani_zmb_video`
  ADD CONSTRAINT `ck_zasedani_zmb` FOREIGN KEY (`ck_zasedani_zmb`) REFERENCES `zasedani_zmb` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Omezení pro tabulku `zmb`
--
ALTER TABLE `zmb`
  ADD CONSTRAINT `ck_leader` FOREIGN KEY (`ck_leader`) REFERENCES `clen_zmb` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
