from flask import Flask, send_from_directory
from flask_restful import Api, Resource, reqparse
from flask_cors import CORS #comment this on deployment

from api.HelloApiHandler import HelloApiHandler
from api.AttendanceStats import AttendanceStats
from api.AttendanceStatsDetailed import AttendanceStatsDetailed
from api.PartiesHelpStats import PartiesHelpStats

from api.GeneralData import GeneralData
from api.DropdownEndpoint import DropdownEndpoint
from api.PartiesBasicData import PartiesBasicData
from api.PartiesStats import PartiesStats
from api.PartyData import PartyData
from api.MemberData import MemberData
from api.SessionsData import SessionsData
from api.SessionData import SessionData
from api.SessionAttendance import SessionAttendance
from api.VotesBasicData import VotesBasicData
from api.VoteData import VoteData
from api.CompareQuery import CompareQuery
from api.VotesQuery import VotesQuery

from api.AttendanceDashboard import AttendanceDashboard

app = Flask(__name__, static_url_path='', static_folder='frontend/build')

CORS(app) #comment this on deployment
api = Api(app)

@app.route("/", defaults={'path':''})
def serve(path):
    return send_from_directory(app.static_folder,'index.html')

# pomocne endpointy
api.add_resource(HelloApiHandler, '/flask/hello')
api.add_resource(AttendanceStats, '/flask/attendanceStats')
api.add_resource(AttendanceStatsDetailed, '/flask/attendanceStatsDetailed')
api.add_resource(PartiesHelpStats, '/flask/partiesHelpStats')

# endpointy pro FE
api.add_resource(GeneralData, '/flask/generalData')
api.add_resource(DropdownEndpoint, '/flask/dropdownEndpoint')
api.add_resource(SessionsData, '/flask/sessionsData')
api.add_resource(PartiesBasicData, '/flask/partiesData')
api.add_resource(VotesBasicData, '/flask/votesData')
api.add_resource(PartiesStats, '/flask/partiesStats')
api.add_resource(PartyData, '/flask/party/<int:party_id>')
api.add_resource(MemberData, '/flask/member/<int:member_id>')
api.add_resource(SessionData, '/flask/session/<int:session_id>')
api.add_resource(SessionAttendance, '/flask/sessionAttendance/<int:session_id>')
api.add_resource(VoteData, '/flask/vote/<int:vote_id>')
api.add_resource(CompareQuery, '/flask/compare')
api.add_resource(VotesQuery, '/flask/votes')

# staticky endpoint
api.add_resource(AttendanceDashboard, '/flask/attendanceDashboard')