from flask import request
from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici hlasovani vyhovujici vstupnim parametrum

'''

class VotesQuery(Resource):
  def get(self):

    args = request.args

    # ulozeni parametru do vlastni struktury
    params = {}
    for key in args:
        params[key] = request.args.get(key)

    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    data = []

    onlyValid = ''
    if 'pouze_platna' in params.keys():
        if params['pouze_platna'] == 'true':
            onlyValid = ' AND hlasovani.validni_hlasovani=1'

    voterResult = ''
    if 'vysledek_volice' in params.keys():
        # ziskani textu podle ID
        sql ="SELECT text from vysledek_volice WHERE id=%s"
        dbHandler.cursor.execute(sql, (params['vysledek_volice'],))
        row = dbHandler.cursor.fetchone()
        text = row[0]

        # ziskani ID odpovidajici s/bez VK moznosti
        if '(VK)' in text:
            text.split(' (VK)')
            sql ="SELECT id from vysledek_volice WHERE text=%s"
            dbHandler.cursor.execute(sql, (text[0]))
        else:
            sql ="SELECT id from vysledek_volice WHERE text=%s"
            dbHandler.cursor.execute(sql, (text + ' (VK)',))
            row = dbHandler.cursor.fetchone()
            id = row[0]

        voterResult = ' AND (hlasovani_clena.ck_vysledek_volice=' + str(params['vysledek_volice']) +' OR hlasovani_clena.ck_vysledek_volice='+ str(id) + ')'

    pollResult = ''
    if 'vysledek_hlasovani' in params.keys():
        pollResult = ' AND vysledek_hlasovani.id=' + params['vysledek_hlasovani']


    # jednotlive moznosti pohledu
    if params['pohled'] == 'zasedani':
        sql = "SELECT hlasovani.id, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text FROM hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani=vysledek_hlasovani.id WHERE hlasovani.ck_poradi_ZMB=%s AND hlasovani.cislo_zasedani=%s" + onlyValid + pollResult
        try:
            dbHandler.cursor.execute(sql, (orderZMB, params['zasedani']))
        except (mysql.connector.Error):
            return []
        
        for id, cislo_hlasovani, predmet_hlasovani, text in dbHandler.cursor:
            data.append({'id_hlasovani': id, 'cislo_hlasovani': cislo_hlasovani, 'predmet_hlasovani': predmet_hlasovani, 'vysledek': text.lower()})
        
        return data

    
    if params['pohled'] == 'strana':
        sql = "SELECT DISTINCT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text FROM zasedani_zmb JOIN hlasovani ON zasedani_zmb.ck_poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani = vysledek_hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice = vysledek_volice.id JOIN clen_zmb ON hlasovani_clena.ck_clen_ZMB = clen_zmb.id JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB WHERE zasedani_zmb.ck_poradi_ZMB=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN prislusi_k.datum_od AND prislusi_k.datum_do AND prislusi_k.ck_politicka_strana=%s" + onlyValid + voterResult + pollResult
        try:
            dbHandler.cursor.execute(sql, (orderZMB, params['strana']))
        except (mysql.connector.Error):
            return []
        
        for id, cislo_zasedani, cislo_hlasovani, predmet_hlasovani, text in dbHandler.cursor:
            data.append({'id_hlasovani': id,'cislo_zasedani': 'Z8/' + cislo_zasedani, 'cislo_hlasovani': cislo_hlasovani, 'predmet_hlasovani': predmet_hlasovani, 'vysledek': text.lower()})
        
        sql = "SELECT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text FROM zasedani_zmb JOIN hlasovani ON zasedani_zmb.ck_poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani = vysledek_hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice = vysledek_volice.id JOIN clen_zmb ON hlasovani_clena.ck_clen_ZMB = clen_zmb.id JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB WHERE zasedani_zmb.ck_poradi_ZMB=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN prislusi_k.datum_od AND prislusi_k.datum_do AND prislusi_k.ck_politicka_strana=%s" + onlyValid + voterResult + pollResult
        dbHandler.cursor.execute(sql, (orderZMB, params['strana']))

        return { "data" : data, "pocet" : dbHandler.cursor.rowcount}
    
    if params['pohled'] == 'clen':
        sql = "SELECT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text FROM zasedani_zmb JOIN hlasovani ON zasedani_zmb.ck_poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani = vysledek_hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice = vysledek_volice.id JOIN clen_zmb ON hlasovani_clena.ck_clen_ZMB = clen_zmb.id JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB WHERE zasedani_zmb.ck_poradi_ZMB=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN prislusi_k.datum_od AND prislusi_k.datum_do AND clen_zmb.id=%s" + onlyValid + voterResult
        try:
            dbHandler.cursor.execute(sql, (orderZMB, params['clen']))
        except (mysql.connector.Error):
            return []
        
        for id, cislo_zasedani, cislo_hlasovani, predmet_hlasovani, text in dbHandler.cursor:
            data.append({'id_hlasovani': id,'cislo_zasedani': 'Z8/' + cislo_zasedani, 'cislo_hlasovani': cislo_hlasovani, 'predmet_hlasovani': predmet_hlasovani, 'vysledek': text.lower()})
        
        return data
    

    if params['pohled'] == 'text':
        sql = "SELECT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text FROM hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani=vysledek_hlasovani.id WHERE hlasovani.ck_poradi_ZMB=%s AND hlasovani.predmet_hlasovani LIKE '%" + params['text'] + "%'"
        try:
            dbHandler.cursor.execute(sql, (orderZMB,))
        except (mysql.connector.Error):
            return []
        
        for id, cislo_zasedani, cislo_hlasovani, predmet_hlasovani, text in dbHandler.cursor:
            data.append({'id_hlasovani': id, 'cislo_zasedani': 'Z8/' + cislo_zasedani,'cislo_hlasovani': cislo_hlasovani, 'predmet_hlasovani': predmet_hlasovani, 'vysledek': text.lower()})
        
        return data

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return []