from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici zakladni statistiku o hlasovanich

'''

class VotesBasicData(Resource):
  def get(self):
    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    data = {}

    sql = "SELECT cislo_zasedani FROM zasedani_zmb WHERE ck_poradi_ZMB=%s"
    dbHandler.cursor.execute(sql, (orderZMB,))
    data['pocet_zasedani'] = dbHandler.cursor.rowcount

    sql = "SELECT hlasovani.cislo_hlasovani, hlasovani.validni_hlasovani, vysledek_hlasovani.text FROM hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani = vysledek_hlasovani.id WHERE hlasovani.ck_poradi_ZMB=%s AND hlasovani.validni_hlasovani=0"
    dbHandler.cursor.execute(sql, (orderZMB,))
    data['pocet_neplatnych'] = dbHandler.cursor.rowcount

    sql = "SELECT vysledek_hlasovani.text, COUNT(vysledek_hlasovani.text) FROM hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani = vysledek_hlasovani.id WHERE hlasovani.ck_poradi_ZMB=%s AND hlasovani.validni_hlasovani=1 GROUP BY vysledek_hlasovani.text"
    dbHandler.cursor.execute(sql, (orderZMB,))

    for item in dbHandler.cursor:
        if item[0] == 'Přijato':
            data['pocet_prijatych'] = item[1]
        if item[0] == 'Nepřijato':
            data['pocet_neprijatych'] = item[1]
    
    data['pocet_hlasovani'] = data['pocet_prijatych'] + data['pocet_neprijatych'] + data['pocet_neplatnych']

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return data