from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici data o konkretnim hlasovani

'''

class VoteData(Resource):
  def get(self, vote_id):
    
    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    sql = "SELECT CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, hlasovani.validni_hlasovani, hlasovani.jmeno_souboru, DATE_FORMAT(zasedani_zmb.datum_zasedani,'%d.%m.%Y') AS datum_zasedani, TIME_FORMAT(hlasovani.cas,'%T') AS cas, vysledek_hlasovani.text AS hlasovani_text, vysledek_volice.text AS volic_text, COUNT(vysledek_volice.text) AS pocet_odpovedi FROM zasedani_zmb JOIN zmb ON zasedani_zmb.ck_poradi_ZMB=zmb.poradi_ZMB JOIN hlasovani ON zmb.poradi_ZMB=hlasovani.ck_poradi_ZMB JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani=vysledek_hlasovani.id JOIN hlasovani_clena ON hlasovani_clena.ck_cislo_hlasovani=hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice=vysledek_volice.id WHERE zmb.poradi_ZMB=%s AND hlasovani.id=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani GROUP BY vysledek_volice.text"
    dbHandler.cursor.execute(sql, (orderZMB, vote_id))
    
    # kontrola existence ID
    if dbHandler.cursor.rowcount == 0:
        return {'error': 'neexistujici ID'}
    else:
        data = {}
        active = 0
        summary = {}

        for cislo_zasedani, cislo_hlasovani, predmet_hlasovani, validni_hlasovani, jmeno_souboru, datum_zasedani, cas, hlasovani_text, volic_text, pocet_odpovedi in dbHandler.cursor:
            data['cislo_zasedani'] = cislo_zasedani
            data['cislo_hlasovani'] = cislo_hlasovani
            data['predmet_hlasovani'] = predmet_hlasovani
            data['validni_hlasovani'] = validni_hlasovani
            data['soubor'] = jmeno_souboru
            data['datum_cas'] = str(datum_zasedani) + ' ' + str(cas)
            data['vysledek'] = hlasovani_text.lower()
            summary[volic_text.lower()] = pocet_odpovedi

            if volic_text.lower() != 'nepřít.':
                active = active + pocet_odpovedi
        
        # korekce hlasu (slouceni prislusnych moznosti s/bez 'VK')
        keys = summary.keys()
        if 'ano' in keys:
            if 'ano (vk)' in keys:
                summary['ano'] = summary['ano'] + summary['ano (vk)']
                del summary['ano (vk)']
        if 'ne' in keys:
            if 'ne (vk)' in keys:
                summary['ne'] = summary['ne'] + summary['ne (vk)']
                del summary['ne (vk)']
        if 'zdržel se' in keys:
            if 'zdržel se (vk)' in keys:
                summary['zdržel se'] = summary['zdržel se'] + summary['zdržel se (vk)']
                del summary['zdržel se (vk)']
        if 'nehlasoval' in keys:
            if 'nehlasoval (vk)' in keys:
                summary['nehlasoval'] = summary['nehlasoval'] + summary['nehlasoval (vk)']
                del summary['nehlasoval (vk)']
        if 'nepřít.' in keys:
            if 'nepřít. (vk)' in keys:
                summary['nepřít.'] = summary['nepřít.'] + summary['nepřít. (vk)']
                del summary['nepřít. (vk)']

        data['sumarizace'] = {key: value for key, value in sorted(summary.items())}
        data['pritomno'] = active
    
    # hlasy po lidech/stranach
    summaryMembers = {}
    sql = "SELECT politicka_strana.zkratka, CASE when vysledek_volice.text=REPLACE(vysledek_volice.text, ' (VK)', '') then vysledek_volice.text else REPLACE(vysledek_volice.text, ' (VK)', '') END AS modifiedText, clen_zmb.id, clen_zmb.jmeno_clena, clen_zmb.prijmeni_clena FROM zasedani_zmb JOIN zmb ON zasedani_zmb.ck_poradi_ZMB=zmb.poradi_ZMB JOIN hlasovani ON zmb.poradi_ZMB=hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani_clena.ck_cislo_hlasovani=hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice=vysledek_volice.id JOIN clen_zmb ON hlasovani_clena.ck_clen_ZMB = clen_zmb.id JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB JOIN politicka_strana ON prislusi_k.ck_politicka_strana = politicka_strana.id WHERE zmb.poradi_ZMB=%s AND hlasovani.id=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN prislusi_k.datum_od AND prislusi_k.datum_do ORDER BY modifiedText, zkratka, prijmeni_clena"
    dbHandler.cursor.execute(sql, (orderZMB, vote_id))

    for zkratka, modifiedText, id, jmeno_clena, prijmeni_clena in dbHandler.cursor:
        if modifiedText.lower() not in summaryMembers.keys():
            summaryMembers[modifiedText.lower()] = {}
        
        if zkratka not in summaryMembers[modifiedText.lower()].keys():
            summaryMembers[modifiedText.lower()][zkratka] = []
        
        summaryMembers[modifiedText.lower()][zkratka].append({'id': id, 'jmeno': jmeno_clena + ' ' + prijmeni_clena})

    data['sumarizace_po_stranach'] = {}
    sql = "SELECT politicka_strana.id, politicka_strana.zkratka, politicka_strana.barva, CASE when vysledek_volice.text=REPLACE(vysledek_volice.text, ' (VK)', '') then vysledek_volice.text else REPLACE(vysledek_volice.text, ' (VK)', '') END AS modifiedText, COUNT(vysledek_volice.text) AS pocet FROM zasedani_zmb JOIN zmb ON zasedani_zmb.ck_poradi_ZMB=zmb.poradi_ZMB JOIN hlasovani ON zmb.poradi_ZMB=hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani_clena.ck_cislo_hlasovani=hlasovani.id JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice=vysledek_volice.id JOIN clen_zmb ON hlasovani_clena.ck_clen_ZMB = clen_zmb.id JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB JOIN politicka_strana ON prislusi_k.ck_politicka_strana = politicka_strana.id WHERE zmb.poradi_ZMB=%s AND hlasovani.id=%s AND zasedani_zmb.cislo_zasedani=hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN prislusi_k.datum_od AND prislusi_k.datum_do GROUP BY politicka_strana.zkratka, modifiedText ORDER BY modifiedText, pocet DESC"
    dbHandler.cursor.execute(sql, (orderZMB, vote_id))

    for id, zkratka, barva, modifiedText, pocet in dbHandler.cursor:
        if modifiedText.lower() not in data['sumarizace_po_stranach'].keys():
            data['sumarizace_po_stranach'][modifiedText.lower()] = []

        data['sumarizace_po_stranach'][modifiedText.lower()].append({'strana_id': id, 'strana_zkratka': zkratka, 'strana_barva': barva, 'pocet': pocet, 'lide': summaryMembers[modifiedText.lower()][zkratka]})

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return data