from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici data o dochazce v ramci jednoho zasedani

'''

class SessionAttendance(Resource):
  def get(self, session_id):
    
    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    sessionId = '0' + str(session_id) if session_id < 10 else session_id
    data = {
        'cislo_zasedani': sessionId,
        'sumarizace': {},
        'prehled': [],
        'detail': []
    }
    overwiev={}
    present = 0
    partialPresent = 0
    absent = 0

    sql = "SELECT strana_zkratka, strana_barva, dochazka, COUNT(dochazka) as pocet FROM _attendancestatsdetailed WHERE poradi_ZMB=%s GROUP BY strana_zkratka,dochazka ORDER BY strana_zkratka"
    dbHandler.cursor.execute(sql, (session_id,))

    # kontrola existence ID
    if dbHandler.cursor.rowcount == 0:
        return {'error': 'neexistujici ID'}
    else:
        for strana_zkratka, strana_barva, dochazka, pocet in dbHandler.cursor:
            if strana_zkratka not in overwiev.keys():
                overwiev[strana_zkratka] = ({'strana_zkratka': strana_zkratka, 'hodnoty': [0,0,0], 'strana_barva': strana_barva})
                
            # hodnoty: 0 - 'přítomnost', 1 - 'částečně přítomnost', 2 - 'nepřítomnost'
            if dochazka == 'přítomnost':
                overwiev[strana_zkratka]['hodnoty'][0] = pocet
                present = present + pocet
            
            if dochazka == 'částečná přítomnost':
                overwiev[strana_zkratka]['hodnoty'][1] = pocet
                partialPresent = partialPresent + pocet
            
            if dochazka == 'nepřítomnost':
                overwiev[strana_zkratka]['hodnoty'][2] = pocet
                absent = absent + pocet
    
    for key, value in overwiev.items():
        data['prehled'].append(value)
    
    data['sumarizace'] = {'přítomnost': present, 'částečná přítomnost': partialPresent, 'nepřítomnost': absent}

    sql = "SELECT strana_id, strana_zkratka, strana_barva, clen_ZMB_id, clen_ZMB, dochazka FROM _attendancestatsdetailed WHERE poradi_ZMB=%s ORDER BY dochazka, strana_zkratka"
    dbHandler.cursor.execute(sql, (session_id,))

    presentOptions = []
    partialPresentOptions = []
    absentOptions = []
    for strana_id, strana_zkratka, strana_barva, clen_ZMB_id, clen_ZMB, dochazka in dbHandler.cursor:
        if dochazka == 'přítomnost':
            if not any(d['strana_id'] == strana_id for d in presentOptions):
                presentOptions.append({'strana_id': strana_id, 'strana_zkratka': strana_zkratka, 'strana_barva': strana_barva, 'clenove': []})
            idx = next((idx for (idx, d) in enumerate(presentOptions) if d['strana_id'] == strana_id), None)
            presentOptions[idx]['clenove'].append({'clen_id': clen_ZMB_id, 'clen_jmeno': clen_ZMB})
            
        if dochazka == 'částečná přítomnost':
            if not any(d['strana_id'] == strana_id for d in partialPresentOptions):
                partialPresentOptions.append({'strana_id': strana_id, 'strana_zkratka': strana_zkratka, 'strana_barva': strana_barva, 'clenove': []})
            idx = next((idx for (idx, d) in enumerate(partialPresentOptions) if d['strana_id'] == strana_id), None)
            partialPresentOptions[idx]['clenove'].append({'clen_id': clen_ZMB_id, 'clen_jmeno': clen_ZMB})
        
        if dochazka == 'nepřítomnost':
            if not any(d['strana_id'] == strana_id for d in absentOptions):
                absentOptions.append({'strana_id': strana_id, 'strana_zkratka': strana_zkratka, 'strana_barva': strana_barva, 'clenove': []})
            idx = next((idx for (idx, d) in enumerate(absentOptions) if d['strana_id'] == strana_id), None)
            absentOptions[idx]['clenove'].append({'clen_id': clen_ZMB_id, 'clen_jmeno': clen_ZMB})
    
    data['detail'] = [presentOptions, partialPresentOptions, absentOptions]

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return data