from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici data o konkretnim zastupiteli

'''

class MemberData(Resource):
  def get(self, member_id):

    # vyjimka - zastupitelka Cerna/Svarcova
    if member_id == 44:
        member_id = 56
    
    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    member = [] 
    orderZMB = 8

    sql = "SELECT cislo_zasedani, DATE_FORMAT(datum_zasedani,'%d.%m.%Y') FROM zasedani_zmb WHERE ck_poradi_ZMB=%s ORDER BY `datum_zasedani` DESC"
    dbHandler.cursor.execute(sql, (orderZMB,))
    row = dbHandler.cursor.fetchone()
    dateOfLastSession = str(row[1])
    
    sql = "SELECT DISTINCT clen_zmb.id, clen_zmb.jmeno_clena, clen_zmb.prijmeni_clena, clen_zmb.pohlavi, clen_zmb.foto, clen_zmb.zdroj FROM clen_zmb INNER JOIN prislusi_k ON clen_zmb.id=prislusi_k.ck_clen_ZMB WHERE prislusi_k.ck_poradi_ZMB=%s AND clen_zmb.id=%s"
    dbHandler.cursor.execute(sql, (orderZMB, member_id))

    # kontrola existence ID
    if dbHandler.cursor.rowcount == 0:
        return {'error': 'neexistujici ID'}
    else:
        row = dbHandler.cursor.fetchone()

    # vytvoreni struktury clena
    member = {
        'id': row[0], 
        'jmeno': row[1] + ' ' + row[2],
        'pohlavi': row[3],
        'foto': row[4],
        'aktivni_clen': 0,
        'zdroj' : row[5],
        'politicke_strany': [],
        'zasedani': []
    }
    
    # data pro 'politicke_strany'
    parties = []
    sql = "SELECT politicka_strana.id, politicka_strana.zkratka, politicka_strana.barva, prislusi_k.datum_od, prislusi_k.datum_do FROM prislusi_k INNER JOIN politicka_strana ON politicka_strana.id=prislusi_k.ck_politicka_strana WHERE prislusi_k.ck_poradi_ZMB=%s AND prislusi_k.ck_clen_ZMB=%s ORDER BY datum_do"
    dbHandler.cursor.execute(sql, (orderZMB, member['id']))
    
    # prislusnost ve stranach od-do
    result = []
    for id, zkratka, barva, datum_od, datum_do in dbHandler.cursor:
        result.append({'id': id, 'zkratka': zkratka, 'strana_barva': barva, 'datum_od': datum_od, 'datum_do': datum_do})

    # pocet zasedani pod kazdou zjistenou stranou (chronologicky)
    for item in result:
        sql = "SELECT COUNT(*) FROM zasedani_zmb WHERE ck_poradi_ZMB=%s AND datum_zasedani>=%s AND datum_zasedani<=%s"
        dbHandler.cursor.execute(sql, (orderZMB, item['datum_od'], item['datum_do']))
        row = dbHandler.cursor.fetchone()
        
        datumOd = str(item['datum_od']).split("-")
        datumDo = str(item['datum_do']).split("-")
        datumDo = datumDo[2] + '.' + datumDo[1] + '.' + datumDo[0]
        
        parties.append({
            'id': item['id'],
            'zkratka': item['zkratka'], 
            'strana_barva': item['strana_barva'],
            'datum_od': datumOd[2] + '.' + datumOd[1] + '.' + datumOd[0], 
            'datum_do': datumDo, 
            'pocet_zasedani_v_ramci_strany': row[0]
        })

        if datumDo == dateOfLastSession:
            member['aktivni_clen'] = 1

        # razeni od nejnovejsiho po historii
        member['politicke_strany'] = parties[::-1]

    # data pro 'zasedani'
    sql = "SELECT cislo_zasedani FROM zasedani_zmb WHERE ck_poradi_ZMB=%s"
    dbHandler.cursor.execute(sql, (orderZMB,))
    totalSessions = dbHandler.cursor.rowcount

    # ziskani cisel zasedani
    sessions = []
    for cislo_zasedani in dbHandler.cursor:
        sessions.append(cislo_zasedani[0])

    # jednotliva platna hlasovani v ramci zasedani
    for session in sessions:
        sql = "SELECT vysledek_volice.text, COUNT(*) AS count FROM zmb JOIN hlasovani ON zmb.poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_volice ON hlasovani_clena.ck_vysledek_volice = vysledek_volice.id WHERE hlasovani.ck_poradi_ZMB=%s AND hlasovani.cislo_zasedani=%s AND hlasovani_clena.ck_clen_ZMB=%s AND hlasovani.validni_hlasovani=1 GROUP BY vysledek_volice.text ORDER BY vysledek_volice.id"
        dbHandler.cursor.execute(sql, (orderZMB, session, member['id']))

        # pouze pokud clen mel pro dane zasedani mandat
        if dbHandler.cursor.rowcount != 0:
            voteOptions = {'cislo_zasedani' : 'Z' + str(orderZMB) + '/' + str(session)}
            for text, count in dbHandler.cursor:
                voteOptions[text.lower()] = count
            
            member['zasedani'].append(voteOptions)

    # data pro 'hlasovani' a jejich sumarizaci
    countActive = 0
    countRemote = 0
    summary = {}
    for session in member['zasedani']:
        for key in session:
            if key not in summary.keys():
                if key != 'cislo_zasedani':
                    summary[key] = int(session[key])
            else:
                summary[key] = summary[key] + int(session[key])

            if key in ['ano (vk)', 'ne (vk)', 'zdržel se (vk)', 'nehlasoval (vk)']:
                countRemote = countRemote + int(session[key])
            
            if key not in ['cislo_zasedani', 'nepřít.', 'nepřít. (vk)']:     # pouze tyto moznosti, u nehlasoval byl zastupitel pritomny
                countActive = countActive + int(session[key])               

    # korekce hlasu (slouceni prislusnych moznosti s/bez 'VK')
    keys = summary.keys()
    if 'ano' in keys:
        if 'ano (vk)' in keys:
            summary['ano'] = summary['ano'] + summary['ano (vk)']
            del summary['ano (vk)']
    if 'ne' in keys:
        if 'ne (vk)' in keys:
            summary['ne'] = summary['ne'] + summary['ne (vk)']
            del summary['ne (vk)']
    if 'zdržel se' in keys:
        if 'zdržel se (vk)' in keys:
            summary['zdržel se'] = summary['zdržel se'] + summary['zdržel se (vk)']
            del summary['zdržel se (vk)']
    if 'nehlasoval' in keys:
        if 'nehlasoval (vk)' in keys:
            summary['nehlasoval'] = summary['nehlasoval'] + summary['nehlasoval (vk)']
            del summary['nehlasoval (vk)']
    if 'nepřít.' in keys:
        if 'nepřít. (vk)' in keys:
            summary['nepřít.'] = summary['nepřít.'] + summary['nepřít. (vk)']
            del summary['nepřít. (vk)']

    member['hlasovani'] = {
        'aktivni_platna' : countActive,
        'ucast' : {
            'prezenčně': countActive-countRemote
        },
        'sumarizace' : {key: value for key, value in sorted(summary.items())}
    }
    if countRemote != 0:
        member['hlasovani']['ucast']['distančně'] = countRemote
        
    if summary['nepřít.'] != 0:
        member['hlasovani']['ucast']['nepřít.'] = summary['nepřít.']
    
    # data pro 'dochazka' a jejich sumarizaci
    totalPresent = 0
    totalPartiallyPresent = 0
    totalAbsent = 0 

    for session in member['zasedani']:
        if len(session) == 2:
            # "cislo_zasedani" + jedna dalsi moznost
            if list(session.keys()) == ['cislo_zasedani', 'nepřít.']:
                totalAbsent += 1
            else:
                totalPresent += 1
        
        if len(session) > 2:
            # "neprit." je v možnostech
            if 'nepřít.' in session.keys():
                totalPartiallyPresent += 1
            # "neprit." neni v možnostech
            else:
                totalPresent += 1

    summaryOptions = ['přítomnost', 'částečná přítomnost', 'nepřítomnost']
    summaryCounts = [totalPresent, totalPartiallyPresent, totalAbsent]
    summaryResult = {}
    for idx, option in enumerate(summaryOptions):
        if summaryCounts[idx] > 0:
            summaryResult[summaryOptions[idx]] = summaryCounts[idx]

    member['dochazka'] = {
        'celkem_zasedani' : totalSessions,
        'mandat' : len(member['zasedani']),
        'sumarizace': summaryResult
    }

    # na frontendu puvodni data nejsou treba -> ale data o zasedanich ano
    member['zasedani'] = {
        'přítomnost': [],
        'částečná přítomnost': [],
        'nepřítomnost': []
    }

    sql = "SELECT poradi_ZMB, strana_barva, dochazka FROM _attendancestatsdetailed WHERE clen_ZMB_id =%s"
    dbHandler.cursor.execute(sql, (member['id'],))

    for poradi_ZMB, strana_barva, dochazka in dbHandler.cursor:
        member['zasedani'][dochazka].append({'zmb': poradi_ZMB, 'barva': strana_barva})

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return member