from flask_restful import Api, Resource, reqparse
import mysql.connector

from api.DatabaseHandler import DatabaseHandler

'''

Endpoint vracejici cleny zastupitelstva do komponenty Dropdown

'''

class DropdownEndpoint(Resource):
  def get(self):
    
    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    data = {'clenove' : [], 'zasedani' : [], 'strany': []}

    # clenove
    sql = "SELECT DISTINCT clen_zmb.id, clen_zmb.jmeno_clena, clen_zmb.prijmeni_clena FROM clen_zmb JOIN prislusi_k ON clen_zmb.id = prislusi_k.ck_clen_ZMB WHERE prislusi_k.ck_poradi_ZMB=%s ORDER BY clen_zmb.prijmeni_clena"
    dbHandler.cursor.execute(sql, (orderZMB,))

    for id, jmeno_clena, prijmeni_clena in dbHandler.cursor:
        data['clenove'].append({ 'name': jmeno_clena + ' ' + prijmeni_clena, 'code': id })

    # zasedani
    sql = "SELECT zasedani_zmb.cislo_zasedani FROM zasedani_zmb WHERE zasedani_zmb.ck_poradi_ZMB=%s"
    dbHandler.cursor.execute(sql, (orderZMB,))

    for cislo_zasedani in dbHandler.cursor:
        number = str(cislo_zasedani[0])
        if cislo_zasedani[0] < 10:
            number = '0' + str(cislo_zasedani[0])
        data['zasedani'].append({ 'name': 'Z8/' + number, 'code': cislo_zasedani[0] })

    # strany    
    sql = "SELECT DISTINCT politicka_strana.id, politicka_strana.zkratka FROM politicka_strana JOIN prislusi_k ON politicka_strana.id = prislusi_k.ck_politicka_strana WHERE prislusi_k.ck_poradi_ZMB=%s ORDER BY politicka_strana.zkratka"
    dbHandler.cursor.execute(sql, (orderZMB,))

    for id, zkratka in dbHandler.cursor:
        data['strany'].append({ 'name': zkratka, 'code': id })
    

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return data