from flask import request
from flask_restful import Api, Resource, reqparse
import mysql.connector

'''

Endpoint pro porovnani dvou zastupitelu

'''

from api.DatabaseHandler import DatabaseHandler

class CompareQuery(Resource):
  def get(self):

    args = request.args

    # ulozeni parametru do vlastni struktury
    params = {}
    for key in args:
        params[key] = request.args.get(key)

    # navazani spojeni s db
    dbHandler = DatabaseHandler()

    # ziskani potrebnych dat
    orderZMB = 8
    data = {}

    # prvni clen
    sql = "SELECT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text, hlasovani_clena.ck_vysledek_volice FROM zasedani_zmb JOIN zmb ON zasedani_zmb.ck_poradi_ZMB = zmb.poradi_ZMB JOIN hlasovani ON zmb.poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani=vysledek_hlasovani.id WHERE zmb.poradi_ZMB=%s AND zasedani_zmb.cislo_zasedani = hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN %s AND %s AND hlasovani.validni_hlasovani=1 AND hlasovani_clena.ck_clen_ZMB=%s"
    dbHandler.cursor.execute(sql, (orderZMB, params['datum_od'], params['datum_do'], params['prvni_clen'] ))

    rowCountFst = dbHandler.cursor.rowcount
    if rowCountFst == 0:
        return {'error': 'neexistujici ID'}
    
    sessions = []
    dataFirst = []
    for id, cislo_zasedani, cislo_hlasovani, predmet_hlasovani, text, ck_vysledek_volice in dbHandler.cursor:
        sessionId = 'Z8/' + cislo_zasedani
        if { 'name': sessionId, 'code': int(cislo_zasedani) } not in sessions:
            sessions.append({ 'name': sessionId, 'code': int(cislo_zasedani) })
        
        dataFirst.append({
            'cislo_zasedani' : sessionId,
            'cislo_hlasovani' : cislo_hlasovani,
            'id_hlasovani' : id,
            'predmet_hlasovani' : predmet_hlasovani,
            'vysledek' : text.lower(),
            'shoda': ck_vysledek_volice
        })

    # druhy clen
    sql = "SELECT hlasovani.id, CASE when hlasovani.cislo_zasedani<10 then LPAD(hlasovani.cislo_zasedani, 2, 0) else hlasovani.cislo_zasedani END AS cislo_zasedani, hlasovani.cislo_hlasovani, hlasovani.predmet_hlasovani, vysledek_hlasovani.text, hlasovani_clena.ck_vysledek_volice FROM zasedani_zmb JOIN zmb ON zasedani_zmb.ck_poradi_ZMB = zmb.poradi_ZMB JOIN hlasovani ON zmb.poradi_ZMB = hlasovani.ck_poradi_ZMB JOIN hlasovani_clena ON hlasovani.id = hlasovani_clena.ck_cislo_hlasovani JOIN vysledek_hlasovani ON hlasovani.ck_vysledek_hlasovani=vysledek_hlasovani.id WHERE zmb.poradi_ZMB=%s AND zasedani_zmb.cislo_zasedani = hlasovani.cislo_zasedani AND zasedani_zmb.datum_zasedani BETWEEN %s AND %s AND hlasovani.validni_hlasovani=1 AND hlasovani_clena.ck_clen_ZMB=%s"
    dbHandler.cursor.execute(sql, (orderZMB, params['datum_od'], params['datum_do'], params['druhy_clen'] ))

    rowCountSnd = dbHandler.cursor.rowcount
    if rowCountSnd == 0:
        return {'error': 'neexistujici ID'}

    if (rowCountFst != rowCountSnd):
        return {'error': 'neexistujici ID'}

    cnt = 0
    complianceCnt = 0

    # docasne mapovani kvuli VK (vlozene karte)
    resultPairs = {
        1: 1, 
        2: 2,
        3: 3,
        4: 4,
        5: 5,
        6: 1,
        7: 5,
        8: 3,
        9: 2,
        10: 4
    }

    for id, cislo_zasedani, cislo_hlasovani, predmet_hlasovani, text, ck_vysledek_volice in dbHandler.cursor:
        sessionId = 'Z8/' + cislo_zasedani
        if sessionId not in data.keys():
            data[sessionId] = {'shoda' : [], 'neshoda' : []}

        if resultPairs[dataFirst[cnt]['shoda']] == resultPairs[ck_vysledek_volice]:
            dataFirst[cnt]['shoda'] = 'ano'
            data[sessionId]['shoda'].append(dataFirst[cnt])
            complianceCnt = complianceCnt + 1
        else:
            dataFirst[cnt]['shoda'] = 'ne'
            data[sessionId]['neshoda'].append(dataFirst[cnt])
        
        cnt = cnt + 1

    data = {
        'zasedani': sessions,
        'shoda': complianceCnt,
        'neshoda': len(dataFirst) - complianceCnt,
        'data': data
    }

    # ukonceni spojeni s db
    dbHandler.closeConnection()
    
    return data