"""
A ctypes interface for librectify
"""

__version__ = "0.9.11"

from image_geometry.line_segments import LineSegments

from .interface import detect_line_segments


def find_lines(image, max_size=1000, smooth=0):
    l, f = detect_line_segments(image, max_size=max_size, smooth=smooth)
    return LineSegments(l, **f)
