// ----------------------------------------------------------------------
//
//  main.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
// AnPaSim - Anesthesia Patient Simulator
// Created as a part of AQUAS project
// ----------------------------------------------------------------------
// The interface has two ways of use:
// 1) Integration to AQUAS/Medical simulation infrusture (A2K)
// 2) User specified ...

// ----------------------------------------------------------------------
// ...
#define ANPA_MAIN

#include "PatientInfo.h"
#include "SimEngine.h"

//
#include "NMT-Rocuronium.h"
#include "BP-SNP-Model.h"
#include "BP-NTG-Model.h"

//
#include "InfusionProcess.h"
#include "SupportProcesses.h"
#include "NoiseProcess.h"


// ----------------------------------------------------------------------
// MAIN function for user purposes and testing
// ----------------------------------------------------------------------
#ifdef ANPA_MAIN
// ----------------------------------------------------------------------
//
int main(int argc, const char * argv[])
{
    // ------------------------------------------------------------------
    // Simulation STARTING context
    auto            _simc = AQSimContext::EMPTY();
    
    // ------------------------------------------------------------------
    //
    PatModelConfig  _CFG;
    
    //
    _CFG.outputSimValues = false;
    
    // ------------------------------------------------------------------
    // Defining the patient
    _simc->patient = Patient::CREATE();

    // ------------------------------------------------------------------
    // [kg]
    _simc->patient->weight = 100;
    _simc->patient->sex = PatientSex::notRelevant;
    
    // ------------------------------------------------------------------
    // Blood volume either set or estimated from [kg] weight
    _simc->patient->volumeOfBlood = _simc->patient->estimateBloodVolume();
    
    // ------------------------------------------------------------------
    // sensitivity to SNP
    _simc->patient->SNPsensitivity = SNPSensitivity::userdef;
    
    // ------------------------------------------------------------------
    // recirculation constant
    _simc->patient->SNPuserDefined.alpha = 0.4;
    // sensitivity mmHg/(mL/h)
    _simc->patient->SNPuserDefined.K = 0.25;
    // time constants
    _simc->patient->SNPuserDefined.Tau = 50;
    _simc->patient->SNPuserDefined.Ti = 35;
    _simc->patient->SNPuserDefined.Tc = 45;
    
    // ------------------------------------------------------------------
    // NTG
    _simc->patient->NTGuserDefined.Vd = 10; // [L]
    _simc->patient->NTGuserDefined.CL = 2; // [L/min]
    _simc->patient->NTGuserDefined.sensitivity = 3; // 
    
    // ------------------------------------------------------------------
    //
    auto _simu = AQSimulator::CREATE(_simc, _CFG);
    
    // ------------------------------------------------------------------
    // Planning simulation events/processes
    // ------------------------------------------------------------------
    // NoiseProcess::ActivateInSim(_simu, NoiseCFG(0, 3));

    // ------------------------------------------------------------------
    // NMT
    //NMTRocuroniumBasicModel::ActivateInSim(_simu);
    //InfusionProcess::INITBolus(_simu, Drugs::Rocuronium);
    //InfusionProcess::ActivateInSim(_simu, Infusion::FLOW(5, Drugs::Rocuronium));
    
    // ------------------------------------------------------------------
    // BP/SNP
    BPSNPBasicModel::ActivateInSim(_simu);
    
    AQTimeRange _snpInfu(60,40*60);
    
    //
    InfusionProcess::ActivateInSim(_simu, Infusion::FLOW(20, Drugs::SNP),
                                   _snpInfu);
    
    // ------------------------------------------------------------------
    // BP/NTG
    // BPNTGBasicModel::ActivateInSim(_simu);
    
    //
    //InfusionProcess::ActivateInSim(_simu, Infusion::FLOW(20, Drugs::NTG),
    //                               AQTimeRange::TO(4*60));
    
    //
    //InfusionProcess::ActivateInSim(_simu, AQTime::T0(),
    //                               Infusion::BOLUS(20, Drugs::NTG));
    
    // ------------------------------------------------------------------
    //
    Sampler::ActivateInSim(_simu, SamplerCFG(10, "patmod2.csv"));
    
    // ------------------------------------------------------------------
    //
    _simu->stepsTo(AQTime(60*60));
}

//
#endif /* ANPA_MAIN */
