//
//  SupportProcesses.hpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 11/09/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef SupportProcesses_hpp
#define SupportProcesses_hpp

//
#include "SimEngine.h"

// ----------------------------------------------------------------------
// Config structure for Sampler process
struct SamplerCFG {
    // ------------------------------------------------------------------
    // reactivate time steps
    AQTime::Type    timeStep = 1;
    
    // output filename
    rstring logCSVFilename;
    
    // ------------------------------------------------------------------
    //
    SamplerCFG(AQTime::Type stp = 30, const rstring &lgFN = "") {
        //
        timeStep = stp; logCSVFilename = lgFN;
    }
};


// ----------------------------------------------------------------------
// Sampler: in predefined steps, the sampler outputs the current
// model state
class Sampler : public AQSimElement {
protected:
    //
    SamplerCFG  _CFG;
    
    // ------------------------------------------------------------------
    // ... sending the output there...
    FILE        *_logCSVFile = nullptr;
    //
public:
    // ------------------------------------------------------------------
    //
    Sampler(const SamplerCFG &cfg);
    virtual ~Sampler();
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator,
                                      const SamplerCFG &cfg);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
    virtual void        doSample(const AQSimContext &state);
};

#endif /* SupportProcesses_hpp */
