//
//  SimEngine.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

//
#include "SimEngine.h"

// ----------------------------------------------------------------------
//
SIMEL_ptr   AQSimElement::ActivateModel(const SIM_ptr &simulator,
                                        const SIMEL_ptr &model)
{
    // some technical error, lets crash
    if (model == nullptr) {
        //
        throw AQExceptionCodes::emptyModel;
    }
    
    // register this model in the simulator's calendar
    simulator->addElement(model);
    
    //
    return model;
}


// ----------------------------------------------------------------------
// ...
const SIMC_ptr  &AQSimElement::SC() const {
    //
    return partOf->simContext();
}


// ----------------------------------------------------------------------
// Adding a specified amount of infusion to "drg" counter
void    AQSimContext::_addInfusion(Drugs drg, double valueInWUnits)
{
    //
    _infusion[(int) drg] += valueInWUnits;
}

// ----------------------------------------------------------------------
// Adding a specified amount of BOLUS infusion to "drg" counter
void    AQSimContext::_addBolus(Drugs drg, double valueInWUnits)
{
    //
    AQException::ASSERT(drg == Drugs::NTG || drg == Drugs::Rocuronium,
                        AQExceptionCodes::bolusInputNotSupported);
    
    //
    _bolus[(int) drg] += valueInWUnits;
}


// ----------------------------------------------------------------------
//
double  AQSimContext::MAP(bool addingNoise) const {
    //
    auto _noise = (addingNoise == true) ? _MAPNoise : 0;
    
    //
    return patient->MAP0 - _deltaMAP + _noise;
}

// ----------------------------------------------------------------------
// going backwards in the history.
// searching the first element that has modelTime <= tm
SIMC_ptr    AQSimulator::simcHistory(const AQTime &tmAt) const
{
    // ...
    static auto __test = [](const SIMC_ptr &with, const AQTime &tm) {
        //
        return with->_modelTime <= tm;
    };
    
    //
    if (tmAt.valid() == false) {
        //
        return nullptr;
    }
    
    //
    if (__test(_simContext, tmAt) == true) {
        //
        return _simContext;
    }
    
    //
    for (auto hh = _simcHistory.rbegin(); hh != _simcHistory.rend(); hh++) {
        //
        if (__test(*hh, tmAt) == true) {
            //
            return *hh;
        }
    }
    
    //
    return nullptr;
}

// ----------------------------------------------------------------------
// Transferring "from" simulation context to a new one
void    AQSimulator::__moveTo(const AQTime &tnow)
{
    // ------------------------------------------------------------------
    // in case the model time has shifted, i.e. the current state
    // must be stored and new state must be constructed
    if (_simContext->_modelTime < tnow) {
        // ...
        if (_CFG.outputSimValues == true) {
            //
            printUserOutput();
        }
        
        // store the current state
        _simcHistory.emplace_back(_simContext);
        
        // generate the new state
        auto _out = AQSimContext::CLONE(_simContext);
        
        // reseting infusion counters
        _out->_infusion.fill(0);
        _out->_bolus.fill(0);
        
        //
        _out->_modelTime = tnow;
    
        //
        _simContext = _out;
    }
}

// ----------------------------------------------------------------------
// adding anElement to the simulator calendar
bool    AQSimulator::addElement(const SIMEL_ptr &anElement)
{
    //
    if (anElement == nullptr) {
        //
        return false;
    }

    // ------------------------------------------------------------------
    // registering to the simulator
    anElement->partOf = this;
    
    // ...
    _elements.push_back(anElement);
    
    // ------------------------------------------------------------------
    // resorting the sim calendar
    static auto _cmp = [](const SIMEL_ptr &l, const SIMEL_ptr &r) {
        //
        if (l->at() == r->at()) {
            //
            return (int) l->prio > (int) r->prio;
        }
        
        //
        return l->at() < r->at();
    };
    
    // ...
    std::sort(_elements.begin(), _elements.end(), _cmp);
    
    //
    return true;
}

// ----------------------------------------------------------------------
// Next-Event simulator, ...
bool    AQSimulator::stepsTo(const AQTime &tm)
{
    // ------------------------------------------------------------------
    //
    if (_CFG.outputSimValues == true) {
        //
        printUserOutputHeader();
    }
    
    // ------------------------------------------------------------------
    // checking calendar...
    while (_elements.empty() == false) {
        // --------------------------------------------------------------
        // the nearest event (sorted > prio, < time)
        auto _front = _elements.front();
        
        // is behind the designated "tm" end
        if (_front->at() > tm) {
            //
            return true;
        }
        
        // --------------------------------------------------------------
        // event/process is erased from the calendar
        // if the process wants to be rescheduled, it needs ask
        // explicitelly (see bellow)
        _elements.erase(_elements.begin());
        
        // --------------------------------------------------------------
        // shifting the model time to the activation time
        __moveTo(_front->activationTime);
        
        // --------------------------------------------------------------
        // calling the event's behavior
        switch (_front->behavior(_front)) {
                // the element wants to be reactivated
            case SimResponse::reactivate:
                //
                addElement(_front);
                break;
                
                //
            case SimResponse::error:
                //
                return false;
                break;
                
                //
            case SimResponse::ok:
                // remove from the simulator
                _front->partOf = nullptr;
                break;
                
            default:
                break;
        }
    }
    
    //
    return true;
}


// ----------------------------------------------------------------------
// Output formatting
// Time | BP infusion | NMT infusion | BP [mmHg] | Rocuronium | TOF
void    AQSimulator::printUserOutputHeader() const
{
    printf("Time\t|BP_infusion\t|NMT_infusion\t|BP[mmHg]\t|Rocuronium\t|TOF|\n");
}

// ----------------------------------------------------------------------
//
void    AQSimulator::printUserOutput() const
{
    //
    printf("%d\t|", _simContext->_modelTime());
    
    //
    printf("%.2f\t|", _simContext->_infusion[(int) Drugs::SNP]);
    printf("%.2f\t|", _simContext->_infusion[(int) Drugs::Rocuronium]);
    
    //
    printf("%.2f\t|", _simContext->MAP());
    printf("%.2f\t|", _simContext->_rocuroniumTotal);
    
    //
    printf("\n");
}

