//
//  PatientInfo.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#include "PatientInfo.h"
#include "Infusion.h"

// ----------------------------------------------------------------------
// Source: wikipedia
double  Patient::estimateBloodVolume() const
{
    //
    switch (sex) {
        case PatientSex::male:
        case PatientSex::notRelevant:
            // 75 ml/kg
            return (75.0 * weight) / 1000.0;
            break;
            
        case PatientSex::female:
            // 65 ml/kg
            return (65.0 * weight) / 1000.0;
            
        default:
            break;
    }
    
    // default value
    return 6.0;
}

// ----------------------------------------------------------------------
//
Infusion    Patient::initialNMTBolus(Drugs nmtDrug) const
{
    //
    auto    __dil = Dilution::DEF(nmtDrug);
    double  __am = 0.0;
    
    //
    switch (nmtDrug) {
        case Drugs::Rocuronium:
            // 0.6 mg/kg
            __am = 0.6 * weight;
            break;
            
        default:
            break;
    }
    
    //
    if (__am > 0) {
        //
        double _bolusAM = __dil.solutionAmountToAchive(__am);
        
        //
        return Infusion::BOLUS(_bolusAM, nmtDrug);
    }
    
    //
    return Infusion::EMPTY();
}
