//
//  NoiseProcess.h
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 16/09/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef NoiseProcess_hpp
#define NoiseProcess_hpp

//
#include "SimEngine.h"

// ----------------------------------------------------------------------
// Noise generator config (normal distribution)
struct NoiseCFG {
    // ------------------------------------------------------------------
    // [s]
    int     timeStepS = 5;
    
    //
    double  meanValue = 1;
    double  distValue = 1;
    
    // ------------------------------------------------------------------
    //
    NoiseCFG(double m, double d) {
        //
        meanValue = m; distValue = d;
    }
};


// ----------------------------------------------------------------------
// Process generating noise to MAP
class NoiseProcess : public AQSimElement {
protected:
    //
    NoiseCFG    _CFG;
    //
public:
    //
    NoiseProcess(const NoiseCFG &cfg);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator,
                                      const NoiseCFG &cfg);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
};


#endif /* NoiseProcess_hpp */
