//
//  NoiseProcess.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 16/09/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#include "NoiseProcess.h"


// ----------------------------------------------------------------------
//
NoiseProcess::NoiseProcess(const NoiseCFG &cfg) :
    _CFG(cfg), AQSimElement(SimElementPrio::noises)
{
    //
}


// ----------------------------------------------------------------------
//
SIMEL_ptr   NoiseProcess::ActivateInSim(const SIM_ptr &simulator,
                                        const NoiseCFG &cfg)
{
    //
    auto _model = std::make_shared<NoiseProcess>(cfg);
    
    //
    ActivateModel(simulator, _model);
    
    //
    return _model;
}

// ----------------------------------------------------------------------
// noise process...
SimResponse NoiseProcess::behavior(const SIMEL_ptr &selfPTR)
{
    // STL normal/gauss distribution
    std::normal_distribution<double> dis(_CFG.meanValue,
                                         _CFG.distValue);
    
    // rndDevice is unique for the entire simulation
    //
    partOf->simContext()->_MAPNoise = dis(partOf->rndDevice());
    
    // reactivation
    activationTime = activationTime.plusSeconds(_CFG.timeStepS);
    
    //
    return SimResponse::reactivate;
}


