//
//  NMT-Rocuronium.hpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef NMT_Rocuronium_hpp
#define NMT_Rocuronium_hpp

//
#include "SimEngine.h"
#include "Infusion.h"


// ----------------------------------------------------------------------
// ROC/NMT, Model of Rocuronium, NMT
// ----------------------------------------------------------------------
// Working unit expressing amount of ROC in the patient - [mg]
class NMTRocuroniumBasicModel : public AQSimElement {
    //
    //
public:
    //
    NMTRocuroniumBasicModel();
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
    virtual double      currentInfusion() const;
};

#endif /* NMT_Rocuronium_hpp */
