//
//  NMT-Rocuronium.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

//
#include "NMT-Rocuronium.h"


// ----------------------------------------------------------------------
// NMT/Rocuronium model is based on the general compartment model
NMTRocuroniumBasicModel::NMTRocuroniumBasicModel() : AQSimElement(SimElementPrio::models)
{
    //
}

// ----------------------------------------------------------------------
//
SIMEL_ptr   NMTRocuroniumBasicModel::ActivateInSim(const SIM_ptr &simulator)
{
    //
    auto _model = std::make_shared<NMTRocuroniumBasicModel>();
    
    //
    return ActivateModel(simulator, _model);
}

// ----------------------------------------------------------------------
// Discreet event model, 1s time step.
// 3compartment model.
// ----------------------------------------------------------------------
SimResponse NMTRocuroniumBasicModel::behavior(const SIMEL_ptr &selfPTR)
{
    // -----------------------------------------------------------------
    //
    auto &_state = partOf->simContext();
    auto &_X = _state->__rocComps;
    
    // -----------------------------------------------------------------
    // inter-compartment flows, the coefficients come from literature
    // [references], todo
    static  double _k12s = 0.259 / 60.0;
    static  double _k21s = 0.163 / 60.0;
    static  double _k13s = 0.060 / 60.0;
    static  double _k31s = 0.012 / 60.0;
    static  double _k10s = 0.119 / 60.0;
    
    // ------------------------------------------------------------------
    //
    double _x1 = _X[2] * _k21s + _X[3] * _k31s - _X[1] * (_k10s + _k12s + _k13s);
    double _x2 = _X[1] * _k12s - _X[2] * _k21s;
    double _x3 = _X[1] * _k13s - _X[3] * _k31s;

    // ------------------------------------------------------------------
    // inputs: flow [ml/h] and bolus [ml]
    double __kin = _state->infusion(Drugs::Rocuronium);
    double __bolus = _state->bolus(Drugs::Rocuronium);
    
    //
    static auto __dil = Dilution::DEF(Drugs::Rocuronium);
    
    // ------------------------------------------------------------------
    // inputs recomputed to [ug/min] and [ug]
    double _kin = __dil.drugAmountFromInfusion(__kin, 1, AMU::mg);
    double _bolus = __dil.drugAmountFromBolus(__bolus, AMU::mg);
    
    // ------------------------------------------------------------------
    //
    if (_kin > 0) { _x1 += _kin; }
    if (_bolus > 0) { _x1 += _bolus; }
    
    // ------------------------------------------------------------------
    //
    _X[1] += _x1;
    _X[2] += _x2;
    _X[3] += _x3;
    
    // ------------------------------------------------------------------
    //
    double _kgs = _state->patient->weight;
    double _Cp = _X[1] / _state->patient->NMTRocuronium.VcPatient_ml(_kgs);
    
    // ------------------------------------------------------------------
    // living in the context ...
    // output the current level of Rocuronium
    _state->_rocuroniumTotal = _X[1] + _X[2] + _X[3];
    _state->_rocuroniumAmountCentralCompartment = _X[1];
    _state->_rocuroniumCp_mg_ml = _Cp;
    
    // ------------------------------------------------------------------
    //
    int     _fu = floor(_state->patient->NMTRocuronium.effect(_Cp) + 0.5);
    int     __fuLIM = (100 - _fu);
    
    // ------------------------------------------------------------------
    // TOF1
    partOf->simContext()->_TOF.set(0, std::min(100, std::max(__fuLIM, 0)));
    
    // ------------------------------------------------------------------
    // next reactivation of the process/event
    // ------------------------------------------------------------------
    // 1s
    activationTime = activationTime.plusSeconds(1);
    
    //
    return SimResponse::reactivate;
}


// ----------------------------------------------------------------------
// specifying the current infusion source, i.e. Rocuronium
double  NMTRocuroniumBasicModel::currentInfusion() const
{
    //
    return partOf->simContext()->infusion(Drugs::Rocuronium);
}
