//
//  InfusionProcess.hpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef InfusionProcess_hpp
#define InfusionProcess_hpp

//
#include "SimEngine.h"
#include "Infusion.h"

// ----------------------------------------------------------------------
// Model of Infusion Process, i.e. simulation event/process
// increasing the current in-flow of the drug
// ----------------------------------------------------------------------
class InfusionProcess : public AQSimElement {
    // ------------------------------------------------------------------
    // Infusion specification (units, type)
    // Flow/bolus
    Infusion        _infusion;
    AQTimeRange     _rangeOfTime;
    
public:
    // ------------------------------------------------------------------
    // Bolus initiated at "at", adding "infu" of "drug"
    InfusionProcess(const AQTime &at, const Infusion &infu);
    
    // ------------------------------------------------------------------
    // Continuous flow of "drg", "infu"
    InfusionProcess(const Infusion &infu, const AQTimeRange &tr = AQTimeRange());
    
    // ------------------------------------------------------------------
    // Constructors
    static  SIMEL_ptr    INITBolus(const SIM_ptr &simulator, Drugs drg);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator,
                                      const Infusion &infu,
                                      const AQTimeRange &tr = AQTimeRange());
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator,
                                      const AQTime &at,
                                      const Infusion &infu);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
};



#endif /* InfusionProcess_hpp */
