//
//  Infusion.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#include "Infusion.h"

// ----------------------------------------------------------------------
//
double  percentLim(double percDecr)
{
    //
    return std::min(std::max(percDecr, 0.0), 100.0);
}

// ----------------------------------------------------------------------
//
double  percentOfLim(double baseValue, double percDecr)
{
    //
    return (baseValue / 100.0) * percentLim(percDecr);
}

// ----------------------------------------------------------------------
//
Dilution    Dilution::DEF(Drugs drg)
{
    //
    switch (drg) {
        case Drugs::SNP:
            //
            return Dilution(50, 250);
            break;
            
        case Drugs::Rocuronium:
            //
            return Dilution(10, 1);
            break;
            
        case Drugs::NTG:
            //
            return Dilution(50, 250);
            break;
            
        default:
            break;
    }
    
    //
    return UNIT();
}

// ----------------------------------------------------------------------
//
double  __mgTo(double amount, AMU outputUnit)
{
    //
    switch (outputUnit) {
        case AMU::ug:
            //
            return amount * 1000.0;
            break;
            
        case AMU::ng:
            //
            return amount * 1000.0 * 1000.0;
            break;
            
        case AMU::mg:
            //
            return amount;
            break;
            
        default:
            break;
    }
    
    //
    throw AQException(AQExceptionCodes::wrongUnits, "mgTo-units");
    
    //
    return amount;
}

// ----------------------------------------------------------------------
// input: number of mililiters of drug solution
// output: amount of drug in [mg]
double  Dilution::drugAmountFromBolus(double mlsOfBolus, AMU outputUnit) const
{
    //
    return __mgTo(mlsOfBolus * mgsInMl, outputUnit);
}



// ----------------------------------------------------------------------
//
double  Dilution::drugAmountFromInfusion(double mlsPerHour,
                                         int duringSeconds,
                                         AMU outputUnit) const
{
    //
    double __timePortion = (double) duringSeconds / 3600.0;
    
    //
    return __mgTo((mgsInMl * mlsPerHour) * __timePortion, outputUnit);
}

// ----------------------------------------------------------------------
//
double  Dilution::solutionAmountToAchive(double absAmountOfDrugMG) const
{
    //
    return absAmountOfDrugMG / mgsInMl;
}
