//
//  BasicDefs.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 26/08/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#include "BasicDefs.h"


// ----------------------------------------------------------------------
//
void    AQException::ASSERT(bool value, AQExceptionCodes cd,
                            const rstring &txt)
{
    //
    if (value == false) {
        //
        throw AQException(cd, txt);
    }
}

// ----------------------------------------------------------------------
//
void    AQException::print() const
{
    //
    printf("Exception code %d, comment: %s\n",
           (int)code, comment.c_str());
}

// ----------------------------------------------------------------------
//
AQTime::AQTime(Type st0)
{
    //
    modelTime = st0;
    
    //
    if (modelTime < 0) {
        //
        throw AQExceptionCodes::undefTimeMoment;
    }
}

// ----------------------------------------------------------------------
//
AQTime::AQTime(const AQTime &from, Type st0, bool mustBeValid)
{
    //
    modelTime = st0;
    
    //
    if (mustBeValid == true && modelTime < 0) {
        //
        throw AQExceptionCodes::undefTimeMoment;
    }
}
