//
//  BP-Models.hpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 09/09/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef BP_Models_hpp
#define BP_Models_hpp

//
#include "SimEngine.h"
#include "Infusion.h"


// ----------------------------------------------------------------------
// BP Model, Sodium Nitroprusside (SNP)
// ----------------------------------------------------------------------
class BPSNPBasicModel : public AQSimElement {
    //
    BPSNPBasicModelCoeffs   _COEFFs;
    //
public:
    // ------------------------------------------------------------------
    //
    BPSNPBasicModel(const BPSNPBasicModelCoeffs &cfs);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   BP_SNP(const BPSNPBasicModelCoeffs &cfs) {
        //
        return std::make_shared<BPSNPBasicModel>(cfs);
    }
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   BP_SNP(const Patient &forPatient);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
};

#endif /* BP_Models_hpp */
