//
//  BP-NMT-Model.hpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 14/11/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#ifndef BP_NMT_Model_hpp
#define BP_NMT_Model_hpp

//
#include "SimEngine.h"
#include "Infusion.h"


// ----------------------------------------------------------------------
// BP Model, Nitroglycerin, Glyceryl Trinitrate (NTG)
// ----------------------------------------------------------------------
class BPNTGBasicModel : public AQSimElement {
    //
    BPNTGModelCoeffs        _COEFFs;
    //
public:
    // ------------------------------------------------------------------
    //
    BPNTGBasicModel(const BPNTGModelCoeffs &cfs);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   BP_NTG(const BPNTGModelCoeffs &cfs) {
        //
        return std::make_shared<BPNTGBasicModel>(cfs);
    }
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   BP_NTG(const Patient &forPatient);
    
    // ------------------------------------------------------------------
    //
    static  SIMEL_ptr   ActivateInSim(const SIM_ptr &simulator);
    
    // ------------------------------------------------------------------
    //
    virtual SimResponse behavior(const SIMEL_ptr &selfPTR);
};


#endif /* BP_NMT_Model_hpp */
