//
//  BP-NMT-Model.cpp
//  ModelAQUAS-gen2
//
//  Created by Martin Hruby on 14/11/2019.
//  Copyright © 2019 Martin Hruby. All rights reserved.
//

#include "BP-NTG-Model.h"


// ----------------------------------------------------------------------
// ...
// ----------------------------------------------------------------------
BPNTGBasicModel::BPNTGBasicModel(const BPNTGModelCoeffs &cfs) : AQSimElement(SimElementPrio::models)
{
    //
    _COEFFs = cfs;
}

// ----------------------------------------------------------------------
//
SIMEL_ptr   BPNTGBasicModel::BP_NTG(const Patient &forPatient)
{
    //
    return std::make_shared<BPNTGBasicModel>(forPatient.NTGuserDefined);
}

// ----------------------------------------------------------------------
//
SIMEL_ptr   BPNTGBasicModel::ActivateInSim(const SIM_ptr &simulator)
{
    //
    auto _model = BPNTGBasicModel::BP_NTG(*simulator->simContext()->patient);
    
    //
    return ActivateModel(simulator, _model);
}


// ----------------------------------------------------------------------
//
SimResponse BPNTGBasicModel::behavior(const SIMEL_ptr &selfPTR)
{
    // ------------------------------------------------------------------
    // inputs: flow [ml/h] and bolus [ml]
    double __kin = SC()->infusion(Drugs::NTG);
    double __bolus = SC()->bolus(Drugs::NTG);
    
    //
    static auto __dil = Dilution::DEF(Drugs::NTG);
    
    // ------------------------------------------------------------------
    // inputs recomputed to [ug/min] and [ug]
    double _kin = __dil.drugAmountFromInfusion(__kin, 60, AMU::ug);
    double _bolus = __dil.drugAmountFromBolus(__bolus, AMU::ug);
    
    // ------------------------------------------------------------------
    // delta C in [ug/min]
    // elimination rate constant Kel is in [min^{-1}]
    double _C = _kin / _COEFFs.Vd - _COEFFs.Kel() * SC()->_NTG_Concentration;
    
    // ------------------------------------------------------------------
    // Euler numerical integration, h = 1s
    SC()->_NTG_Concentration += (_C/60.0);
    SC()->_NTG_Concentration += _bolus / _COEFFs.Vd;
    
    // ------------------------------------------------------------------
    //
    double _percDecr = _COEFFs.sensitivity * SC()->_NTG_Concentration;
    
    // ------------------------------------------------------------------
    // ...
    SC()->_deltaMAP = percentOfLim(SC()->patient->MAP0, _percDecr);
    
    // ------------------------------------------------------------------
    // next reactivation of the process/event
    // ------------------------------------------------------------------
    // 1s
    activationTime = activationTime.plusSeconds(1);
    
    //
    return SimResponse::reactivate;
}
