export const ERROR = {
  INVALID_IP_ADDRESS: "INVALID_IP_ADDRESS",
  INVALID_FILTER_INPUT: "INVALID_FILTER_INPUT",
};

export const validateInput = (address: string, filterInput?: string) => {
  let errors = {};
  if (
    // IPV4
    !address.match(
      /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\/\d\d?)?$/,
    ) &&
    // IPV6
    !address.match(
      /(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))(\/\d\d?)?$/,
    )
  ) {
    errors = {
      ipAddress: ERROR.INVALID_IP_ADDRESS,
    };
  }
  if (!filterInput) {
    return errors;
  }
  if (
    filterInput
      .replace(/\//g, "")
      .replace(/:/g, "")
      .replace(/ /g, "")
      .replace(/-/g, "")
      .match(/^\d+$/) === null
  ) {
    // @ts-ignore
    errors.filterInput = ERROR.INVALID_FILTER_INPUT;
  }
  return errors;
};
