#!/usr/bin/env python3
# -*- coding: utf-8 -*-
""" Run all automatic tests of consensus_parser """
# Copyright (C) 2018 Libor Polčák
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import unittest

import test_files
import test_geolite2
import test_or
import test_cp
import test_additional_info
import test_rest
import test_serializable
import test_time

def suite():
    tests = (
            test_files.suite(),
            test_geolite2.suite(),
            test_or.suite(),
            test_cp.suite(),
            test_additional_info.suite(),
            test_rest.suite(),
            test_serializable.suite(),
            test_time.suite(),
            )
    return unittest.TestSuite(tests)

def test(verbosity=2, failfast=False):
    runner = unittest.TextTestRunner(verbosity=verbosity, failfast=failfast)
    runner.run(suite())

if __name__ == '__main__':
    test(verbosity=1)
