# Copyright (C) 2018 Libor Polčák <ipolcak@fit.vutbr.cz>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


""" This module contains classes needed for snapshoting according to
consensus files."""

from time_parser import TimeWrapper

class Snapshot():

    def __init__(self, obj_lines, orouters):
        self.__obj_lines = obj_lines
        self.__routers = orouters
        self.__unparsed_lines = []
        for line in obj_lines:
            words = line.split()
            parser = None
            try:
                parser = getattr(self, "parse_" + words[0].replace("-", "_"))
            except:
                self.__unparsed_lines.append(line)
            if parser:
                parser(*words[1:])
        self.__ip = {}
        for orouter in orouters:
            orouter.add_network_status_consensus(self.__valid_after,
                    self.__fresh_until, self.__valid_until)
            self.__ip[orouter.get_ip()] = orouter
            ipv6_addrs = [a for a, _ in orouter.get_ipv6()]
            for a in ipv6_addrs:
                self.__ip[a] = orouter

    def get_onion_router(self, ipaddr):
        try:
            return self.__ip[ipaddr]
        except:
            return None

    def get_ipaddrs(self):
        return self.__ip.keys()

    def get_valid_after(self):
        return TimeWrapper(" ".join(self.__valid_after)).get()

    def parse_valid_after(self, date, time):
        self.__valid_after = (date, time)

    def parse_fresh_until(self, date, time):
        self.__fresh_until = (date, time)

    def parse_valid_until(self, date, time):
        self.__valid_until = (date, time)
