@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\io\github\radkovo\vocab-builder-core\1.3-SNAPSHOT\vocab-builder-core-1.3-SNAPSHOT.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-model\2.5.5\rdf4j-model-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-api\2.5.5\rdf4j-rio-api-2.5.5.jar;"%REPO%"\org\apache\commons\commons-lang3\3.3.2\commons-lang3-3.3.2.jar;"%REPO%"\com\google\guava\guava\16.0.1\guava-16.0.1.jar;"%REPO%"\org\slf4j\slf4j-api\1.7.25\slf4j-api-1.7.25.jar;"%REPO%"\io\github\radkovo\vocab-builder-python\1.3-SNAPSHOT\vocab-builder-python-1.3-SNAPSHOT.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.3.6\httpclient-4.3.6.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.3.3\httpcore-4.3.3.jar;"%REPO%"\commons-logging\commons-logging\1.1.3\commons-logging-1.1.3.jar;"%REPO%"\commons-codec\commons-codec\1.6\commons-codec-1.6.jar;"%REPO%"\commons-io\commons-io\2.4\commons-io-2.4.jar;"%REPO%"\commons-cli\commons-cli\1.2\commons-cli-1.2.jar;"%REPO%"\org\slf4j\slf4j-simple\1.7.25\slf4j-simple-1.7.25.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-rdfxml\2.5.5\rdf4j-rio-rdfxml-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-datatypes\2.5.5\rdf4j-rio-datatypes-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-languages\2.5.5\rdf4j-rio-languages-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-util\2.5.5\rdf4j-util-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-ntriples\2.5.5\rdf4j-rio-ntriples-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-nquads\2.5.5\rdf4j-rio-nquads-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-turtle\2.5.5\rdf4j-rio-turtle-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-trig\2.5.5\rdf4j-rio-trig-2.5.5.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-rdfjson\2.5.5\rdf4j-rio-rdfjson-2.5.5.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-core\2.10.0\jackson-core-2.10.0.jar;"%REPO%"\com\github\jsonld-java\jsonld-java-tools\0.10.0\jsonld-java-tools-0.10.0.jar;"%REPO%"\com\github\jsonld-java\jsonld-java\0.10.0\jsonld-java-0.10.0.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-databind\2.10.0\jackson-databind-2.10.0.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-annotations\2.10.0\jackson-annotations-2.10.0.jar;"%REPO%"\org\apache\httpcomponents\httpclient-osgi\4.5.3\httpclient-osgi-4.5.3.jar;"%REPO%"\org\apache\httpcomponents\httpmime\4.5.3\httpmime-4.5.3.jar;"%REPO%"\org\apache\httpcomponents\httpclient-cache\4.3.6\httpclient-cache-4.3.6.jar;"%REPO%"\org\apache\httpcomponents\fluent-hc\4.5.3\fluent-hc-4.5.3.jar;"%REPO%"\org\apache\httpcomponents\httpcore-osgi\4.4.6\httpcore-osgi-4.4.6.jar;"%REPO%"\org\apache\httpcomponents\httpcore-nio\4.4.6\httpcore-nio-4.4.6.jar;"%REPO%"\org\slf4j\jcl-over-slf4j\1.7.23\jcl-over-slf4j-1.7.23.jar;"%REPO%"\org\slf4j\slf4j-log4j12\1.7.23\slf4j-log4j12-1.7.23.jar;"%REPO%"\log4j\log4j\1.2.17\log4j-1.2.17.jar;"%REPO%"\net\sf\jopt-simple\jopt-simple\5.0.3\jopt-simple-5.0.3.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-jsonld\2.2\rdf4j-rio-jsonld-2.2.jar;"%REPO%"\org\eclipse\rdf4j\rdf4j-rio-trix\2.2\rdf4j-rio-trix-2.2.jar;"%REPO%"\org\semarglproject\semargl-rdf4j\0.7\semargl-rdf4j-0.7.jar;"%REPO%"\org\semarglproject\semargl-core\0.7\semargl-core-0.7.jar;"%REPO%"\org\semarglproject\semargl-rdfa\0.7\semargl-rdfa-0.7.jar;"%REPO%"\org\semarglproject\semargl-rdf\0.7\semargl-rdf-0.7.jar;"%REPO%"\io\github\radkovo\vocab-builder-cli\1.3-SNAPSHOT\vocab-builder-cli-1.3-SNAPSHOT.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS%  -classpath %CLASSPATH% -Dapp.name="sesame-vocab-builder" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" com.github.tkurz.sesame.vocab.Main %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
