/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.GraphPatternGroupable;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TupleExprs {
    public static boolean containsSubquery(TupleExpr t) {
        ArrayDeque<TupleExpr> queue = new ArrayDeque<TupleExpr>();
        queue.add(t);
        while (!queue.isEmpty()) {
            TupleExpr n = (TupleExpr)queue.removeFirst();
            if (n instanceof Projection && ((Projection)n).isSubquery()) {
                return true;
            }
            if (n instanceof Join) {
                return false;
            }
            queue.addAll(TupleExprs.getChildren(n));
        }
        return false;
    }

    public static boolean isGraphPatternGroup(TupleExpr expr) {
        if (expr instanceof GraphPatternGroupable) {
            return ((GraphPatternGroupable)((Object)expr)).isGraphPatternGroup();
        }
        return false;
    }

    @Deprecated
    public static boolean containsProjection(TupleExpr t) {
        ArrayDeque<TupleExpr> queue = new ArrayDeque<TupleExpr>();
        queue.add(t);
        while (!queue.isEmpty()) {
            TupleExpr n = (TupleExpr)queue.removeFirst();
            if (n instanceof Projection) {
                return true;
            }
            if (n instanceof Join) {
                return false;
            }
            queue.addAll(TupleExprs.getChildren(n));
        }
        return false;
    }

    public static List<TupleExpr> getChildren(TupleExpr t) {
        final ArrayList<TupleExpr> children = new ArrayList<TupleExpr>(4);
        t.visitChildren(new AbstractQueryModelVisitor<RuntimeException>(){

            @Override
            public void meetNode(QueryModelNode node) {
                if (node instanceof TupleExpr) {
                    children.add((TupleExpr)node);
                }
            }
        });
        return children;
    }

    public static Var createConstVar(Value value) {
        String varName = TupleExprs.getConstVarName(value);
        Var var = new Var(varName);
        var.setConstant(true);
        var.setAnonymous(true);
        var.setValue(value);
        return var;
    }

    public static String getConstVarName(Value value) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        String uniqueStringForValue = Integer.toHexString(value.stringValue().hashCode());
        if (value instanceof Literal) {
            uniqueStringForValue = uniqueStringForValue + "_lit";
            Literal lit = (Literal)value;
            if (lit.getDatatype() != null) {
                uniqueStringForValue = uniqueStringForValue + "_" + Integer.toHexString(lit.getDatatype().hashCode());
            }
            if (lit.getLanguage() != null) {
                uniqueStringForValue = uniqueStringForValue + "_" + Integer.toHexString(lit.getLanguage().hashCode());
            }
        } else {
            uniqueStringForValue = value instanceof BNode ? uniqueStringForValue + "_node" : uniqueStringForValue + "_uri";
        }
        return "_const_" + uniqueStringForValue;
    }
}

