/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class OrderLimitOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new OrderOptimizer());
    }

    protected static class OrderOptimizer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean variablesProjected = true;
        private Projection projection;

        protected OrderOptimizer() {
        }

        @Override
        public void meet(Projection node) {
            this.projection = node;
            node.getArg().visit(this);
            this.projection = null;
        }

        @Override
        public void meet(Order node) {
            QueryModelNode parent;
            for (OrderElem e : node.getElements()) {
                e.visit(this);
            }
            if (this.variablesProjected && this.projection == (parent = node.getParentNode())) {
                node.replaceWith(node.getArg().clone());
                node.setArg(this.projection.clone());
                Order replacement = node.clone();
                this.projection.replaceWith(replacement);
                QueryModelNode distinct = replacement.getParentNode();
                if (distinct instanceof Distinct) {
                    distinct.replaceWith(new Reduced(replacement.clone()));
                }
            }
        }

        @Override
        public void meet(Var node) {
            if (this.projection != null) {
                boolean projected = false;
                for (ProjectionElem e : this.projection.getProjectionElemList().getElements()) {
                    String source = e.getSourceName();
                    String target = e.getTargetName();
                    if (!node.getName().equals(source) || !node.getName().equals(target)) continue;
                    projected = true;
                    break;
                }
                if (!projected) {
                    this.variablesProjected = false;
                }
            }
        }
    }
}

