/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public abstract class User {
    public static final String HBASE_SECURITY_CONF_KEY = "hbase.security.authentication";
    public static final String HBASE_SECURITY_AUTHORIZATION_CONF_KEY = "hbase.security.authorization";
    protected UserGroupInformation ugi;

    public UserGroupInformation getUGI() {
        return this.ugi;
    }

    public String getName() {
        return this.ugi.getUserName();
    }

    public String[] getGroupNames() {
        return this.ugi.getGroupNames();
    }

    public abstract String getShortName();

    public abstract <T> T runAs(PrivilegedAction<T> var1);

    public abstract <T> T runAs(PrivilegedExceptionAction<T> var1) throws IOException, InterruptedException;

    public Token<?> getToken(String kind, String service) throws IOException {
        for (Token token : this.ugi.getTokens()) {
            if (!token.getKind().toString().equals(kind) || service == null || !token.getService().toString().equals(service)) continue;
            return token;
        }
        return null;
    }

    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        return this.ugi.getTokens();
    }

    public void addToken(Token<? extends TokenIdentifier> token) {
        this.ugi.addToken(token);
    }

    public boolean isLoginFromKeytab() {
        return this.ugi.isFromKeytab();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ugi.equals((Object)((User)o).ugi);
    }

    public int hashCode() {
        return this.ugi.hashCode();
    }

    public String toString() {
        return this.ugi.toString();
    }

    public static User getCurrent() throws IOException {
        SecureHadoopUser user = new SecureHadoopUser();
        if (user.getUGI() == null) {
            return null;
        }
        return user;
    }

    public static <T> T runAsLoginUser(PrivilegedExceptionAction<T> action) throws IOException {
        try {
            Class<?> c = Class.forName("org.apache.hadoop.security.SecurityUtil");
            Class[] types = new Class[]{PrivilegedExceptionAction.class};
            Object[] args = new Object[]{action};
            return (T)Methods.call(c, null, "doAsLoginUser", types, args);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public static User create(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        return new SecureHadoopUser(ugi);
    }

    public static User createUserForTesting(Configuration conf, String name, String[] groups) {
        User userForTesting = SecureHadoopUser.createUserForTesting(conf, name, groups);
        return userForTesting;
    }

    public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
        SecureHadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
    }

    public static void login(String keytabLocation, String pricipalName) throws IOException {
        SecureHadoopUser.login(keytabLocation, pricipalName);
    }

    public static boolean isSecurityEnabled() {
        return SecureHadoopUser.isSecurityEnabled();
    }

    public static boolean isHBaseSecurityEnabled(Configuration conf) {
        return "kerberos".equalsIgnoreCase(conf.get(HBASE_SECURITY_CONF_KEY));
    }

    public static boolean shouldLoginFromKeytab(Configuration conf) {
        Optional<String> keytab = Optional.ofNullable(conf.get("hbase.client.keytab.file"));
        Optional<String> principal = Optional.ofNullable(conf.get("hbase.client.keytab.principal"));
        return keytab.isPresent() && principal.isPresent();
    }

    public static class TestingGroups
    extends Groups {
        public static final String TEST_CONF = "hbase.group.service.for.test.only";
        private final Map<String, List<String>> userToGroupsMapping = new HashMap<String, List<String>>();
        private Groups underlyingImplementation;

        public TestingGroups(Groups underlyingImplementation) {
            super(new Configuration());
            this.underlyingImplementation = underlyingImplementation;
        }

        public List<String> getGroups(String user) throws IOException {
            List result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = this.underlyingImplementation.getGroups(user);
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            this.userToGroupsMapping.put(user, Arrays.asList(groups));
        }
    }

    @InterfaceAudience.Private
    public static final class SecureHadoopUser
    extends User {
        private String shortName;
        private LoadingCache<String, String[]> cache;

        public SecureHadoopUser() throws IOException {
            this.ugi = UserGroupInformation.getCurrentUser();
            this.cache = null;
        }

        public SecureHadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
            this.cache = null;
        }

        public SecureHadoopUser(UserGroupInformation ugi, LoadingCache<String, String[]> cache) {
            this.ugi = ugi;
            this.cache = cache;
        }

        @Override
        public String getShortName() {
            if (this.shortName != null) {
                return this.shortName;
            }
            try {
                this.shortName = this.ugi.getShortUserName();
                return this.shortName;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error getting user short name", e);
            }
        }

        @Override
        public String[] getGroupNames() {
            if (this.cache != null) {
                try {
                    return this.cache.get(this.getShortName());
                }
                catch (ExecutionException e) {
                    return new String[0];
                }
            }
            return this.ugi.getGroupNames();
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            return (T)this.ugi.doAs(action);
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            return (T)this.ugi.doAs(action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            Class<UserProvider> clazz = UserProvider.class;
            synchronized (UserProvider.class) {
                if (!(UserProvider.groups instanceof TestingGroups) || conf.getBoolean("hbase.group.service.for.test.only", false)) {
                    UserProvider.groups = new TestingGroups(UserProvider.groups);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                ((TestingGroups)UserProvider.groups).setUserGroups(name, groups);
                return new SecureHadoopUser(UserGroupInformation.createUserForTesting((String)name, (String[])groups));
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            if (SecureHadoopUser.isSecurityEnabled()) {
                SecurityUtil.login((Configuration)conf, (String)fileConfKey, (String)principalConfKey, (String)localhost);
            }
        }

        public static void login(String keytabLocation, String principalName) throws IOException {
            if (SecureHadoopUser.isSecurityEnabled()) {
                UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytabLocation);
            }
        }

        public static boolean isSecurityEnabled() {
            return UserGroupInformation.isSecurityEnabled();
        }
    }
}

