"""
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '..', '')))

import json
import logging
import unittest

from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.ModelsUtil import ModelsUtil
from dm.DateTimeUtil import DateTimeUtil
from dm.WundergroundCom import WundergroundCom

__author__ = ''
__email__ = ''


def to_timestamp(time_str):
    return int(DateTimeUtil.local_time_str_to_utc(time_str).timestamp())


class Test0301Estimate(unittest.TestCase):
    def setUp(self):
        self.cls = cu.setup_clients()
        cu.setup_logging()

    def tearDown(self):
        cu.setup_clients_logout(self.cls)

    @staticmethod
    def es(cls, actual_time, temperature_diff=4):
        actual_time = to_timestamp(actual_time)
        lat = 49.1649894
        lon = 16.562262499999974

        w = WundergroundCom()
        w.api_key = cu.wunderground_api_key()

        devs = [
            {
                'db_column_name': 'temperature_in_celsius',
                'gateway_id': '1816820318180747',
                'device_id': '0xa900811026800001',
                'module_id': 0,
                'server_name': 'ant-work',
            },
            {
                'db_column_name': 'rh_in_percentage',
                'gateway_id': '1816820318180747',
                'device_id': '0xa900811026800001',
                'module_id': 1,
                'server_name': 'ant-work',
            }
        ]

        notification = ModelsUtil.when_ventilate_summer(devs, cls, lat, lon, actual_time, w, temperature_diff=temperature_diff)
        logging.debug(json.dumps(notification, indent=4))
        return notification

    def test_ventilate(self):
        notification = self.es(self.cls, '2019/02/21 07:45:00')
        self.assertEqual(0.5, notification['data']['temp_out'])
        self.assertEqual(23.375, notification['data']['temp_in'])

        # je mozne vetrat
        self.assertEqual(2, notification['data']['ventilate'])

    def test_maybe_ventilate(self):
        notification = self.es(self.cls, '2019/02/21 07:45:00', temperature_diff=23)
        self.assertEqual(0.5, notification['data']['temp_out'])
        self.assertEqual(23.375, notification['data']['temp_in'])

        # je mozne vetrat, ale nebude to mat ucinok, lebo je nastaveny threshold - temperature_diff
        self.assertEqual(1, notification['data']['ventilate'])

    def test_maybe_ventilate_2(self):
        notification = self.es(self.cls, '2019/06/15 12:45:00', temperature_diff=1)
        self.assertEqual(31.0, notification['data']['temp_out'])
        self.assertEqual(30.975, notification['data']['temp_in'])

        # je mozne vetrat, ale nebude to mat ucinok, lebo je nastaveny threshold - temperature_diff
        self.assertEqual(1, notification['data']['ventilate'])

    def test_no_ventilate(self):
        notification = self.es(self.cls, '2019/06/15 12:45:00', temperature_diff=0)
        self.assertEqual(31.0, notification['data']['temp_out'])
        self.assertEqual(30.975, notification['data']['temp_in'])

        # neoplati sa vetrat, vonku je teplejsie
        self.assertEqual(0, notification['data']['ventilate'])


if __name__ == '__main__':
    unittest.main()
