"""
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '..', '')))

import json
import logging
import unittest

from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.ModelsUtil import ModelsUtil
from dm.DateTimeUtil import DateTimeUtil

__author__ = ''
__email__ = ''


def to_timestamp(time_str):
    return int(DateTimeUtil.local_time_str_to_utc(time_str).timestamp())


class Test0301Estimate(unittest.TestCase):
    def setUp(self):
        self.cls = cu.setup_clients()

    def tearDown(self):
        cu.setup_clients_logout(self.cls)

    @staticmethod
    def es_co2(cls, actual_time):
        actual_time = to_timestamp(actual_time)
        devs = [
            {
                'db_column_name': 'co2_in_ppm',
                'gateway_id': '1816820318180747',
                'device_id': '0xa900811026800001',
                'module_id': 2,
                'server_name': 'ant-work',
            }
        ]

        notification = ModelsUtil.estimate_co2(devs, cls, actual_time)
        logging.debug(json.dumps(notification, indent=4))
        return notification

    @staticmethod
    def es_t_h(cls, actual_time):
        actual_time = to_timestamp(actual_time)
        devs = [
            {
                'db_column_name': 'temperature_in2_celsius',
                'gateway_id': '1816820318180747',
                'device_id': '0xa900811026800001',
                'module_id': 0,
                'server_name': 'ant-work',
            },
            {
                'db_column_name': 'rh_in2_percentage',
                'gateway_id': '1816820318180747',
                'device_id': '0xa900811026800001',
                'module_id': 1,
                'server_name': 'ant-work',
            }
        ]

        notification = ModelsUtil.estimate_t_h(devs, cls, actual_time)
        logging.debug(json.dumps(notification, indent=4))
        return notification

    def test_co2_01(self):
        notification = self.es_co2(self.cls, '2019/02/21 07:45:00')
        self.assertEqual(True, notification['raise'])
        self.assertEqual(1, notification['data']['level'])

        # skutocne CO2 after 60 min: 1751ppm
        self.assertEqual(1725, notification['data']['es_level'])
        # cas, za ktory sa dosiahne uroven 1 (1500ppm): 35 min
        self.assertEqual(47, notification['data']['estimate_time'])

    def test_co2_02(self):
        notification = self.es_co2(self.cls, '2019/02/21 09:05:00')
        self.assertEqual(False, notification['raise'])

        notification = self.es_co2(self.cls, '2019/02/22 02:00:00')
        self.assertEqual(False, notification['raise'])

    def test_t_h_01(self):
        notification = self.es_t_h(self.cls, '2019/02/21 07:45:00')
        self.assertEqual(False, notification['raise'])
        self.assertEqual(1, notification['data']['level'])

        # skutocne RH after 60 min: 33.0%
        self.assertEqual(34, notification['data']['es_level'])
        # cas, za ktory sa dosiahne uroven 1 (40%): 78 min
        self.assertEqual(78, notification['data']['estimate_time'])

    def test_t_h_02(self):
        notification = self.es_t_h(self.cls, '2019/02/21 09:05:00')
        self.assertEqual(False, notification['raise'])

        notification = self.es_t_h(self.cls, '2019/02/22 02:00:00')
        self.assertEqual(False, notification['raise'])


if __name__ == '__main__':
    unittest.main()
