"""Initialize general models from local database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.models.ModelsUtil import ModelsUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.predictor.generic_training_file_from_local_db import training_file_t_h


if __name__ == '__main__':
    cu.setup_logging()

    no_event_shift = int(cu.predictor('attrs.no_event.time_shift'))

    data_t_h = training_file_t_h(cu.package('t_h.event_file.name'), no_event_shift)
    t_h_filename = cu.predictor('generic.t_h.model.name') + '_from_local_db.bin'
    ModelsUtil.write_model(data_t_h, t_h_filename, replace=ModelsUtil.replace_ventilation_length)
