"""Initialize general models from a remote server.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

import json

from dm.models.ModelsUtil import ModelsUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.predictor.generic_training_file import training_file_t_h
from dm.WundergroundCom import WundergroundCom


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    # file with devices for training
    with open(cu.open_detector('generic.devices.path'), 'r') as f:
        devs = json.load(f)

    lat = 49.1649894
    lon = 16.562262499999974

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    data_t_h = training_file_t_h(cu.package('t_h.event_file.name'), no_event_shift, cls, devs,
                                 lat, lon, w)
    t_h_filename = cu.predictor('generic.t_h.model.name')
    ModelsUtil.write_model(data_t_h, t_h_filename, replace=ModelsUtil.replace_ventilation_length)
