"""Initialize general models from local database.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.models.ModelsUtil import ModelsUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.predictor.generic_training_file_from_local_db import training_file_co2


if __name__ == '__main__':
    cu.setup_logging()

    no_event_shift = int(cu.predictor('attrs.no_event.time_shift'))

    data_co2 = training_file_co2(cu.package('co2.event_file.name'), no_event_shift)
    co2_filename = cu.predictor('generic.co2.model.name') + '_from_local_db.bin'
    ModelsUtil.write_model(data_co2, co2_filename, replace=ModelsUtil.replace_co2_ventilation_len)
