"""Initialize general models from a remote server.
"""
from os.path import dirname, abspath, join
import sys
sys.path.append(abspath(join(dirname(__file__), '../..', '')))

from dm.models.ModelsUtil import ModelsUtil
from dm.ConnectionUtil import ConnectionUtil as cu
from dm.models.predictor.generic_training_file import training_file_co2
from dm.WundergroundCom import WundergroundCom
import json


if __name__ == '__main__':
    cu.setup_logging()
    cls = cu.setup_clients()

    no_event_shift = int(cu.open_detector('attrs.no_event.time_shift'))

    # file with devices for training
    with open(cu.open_detector('generic.devices.path'), 'r') as f:
        devs = json.load(f)

    lat = 49.1649894
    lon = 16.562262499999974

    w = WundergroundCom()
    w.api_key = cu.wunderground_api_key()

    data_co2 = training_file_co2(cu.package('co2.event_file.name'), no_event_shift, cls, devs,
                                 lat, lon, w)
    co2_filename = cu.predictor('generic.co2.model.name')
    ModelsUtil.write_model(data_co2, co2_filename, replace=ModelsUtil.replace_co2_ventilation_len)
